#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.multiseries_id_columns_record import MultiseriesIdColumnsRecord

class MultiseriesRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    datetime_partition_column:str
         The datetime partition column name.
    detected_multiseries_id_columns:[MultiseriesIdColumnsRecord]
         A list of detected multiseries ID columns along with timeStep and timeUnit information. Note that if no eligible columns have been detected, this list will be empty.
    """
    _converter = t.Dict(
        {
            t.Key("datetime_partition_column"):  t.String(),
            t.Key("detected_multiseries_id_columns"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        datetime_partition_column,
        detected_multiseries_id_columns,
    ):
        self.datetime_partition_column = datetime_partition_column
        self.detected_multiseries_id_columns = detected_multiseries_id_columns

    def __repr__(self):
        return (
            "MultiseriesRetrieveResponse("
            "datetime_partition_column={0.datetime_partition_column}, "
            "detected_multiseries_id_columns={0.detected_multiseries_id_columns}, "
        ).format(self)
