#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.customer_header import CustomerHeader

class NotificationChannelResponse(APIObject):
    """
    Attributes
    ----------
    channel_type:str
         The type of the new notification channel.
    content_type:str, none_type
         The content type of the messages of the new notification channel.
    created_at:datetime
         The date of the notification channel creation.
    custom_headers:[CustomerHeader], none_type
         Custom headers and their values to be sent in the new notification channel.
    email_address:str, none_type
         The email address to be used in the new notification channel.
    id:str
         The id of the notification channel.
    language_code:str, none_type
         The preferred language code.
    last_notification_at:datetime, none_type
         The timestamp of the last notification sent to the channel.
    name:str
         The name of the new notification channel.
    org_id:str, none_type
         The id of organization that notification channel belongs to.
    payload_url:str, none_type
         The payload URL of the new notification channel.
    policy_count:int
         Count of policies assigned to the channel.
    secret_token:str, none_type
         Secret token to be used for new notification channel.
    uid:str, none_type
         The identifier of the user who created the channel.
    validate_ssl:bool, none_type
         Defines if  validate ssl or not in the notification channel.
    """
    _converter = t.Dict(
        {
            t.Key("channel_type"):  t.String(),
            t.Key("content_type"):  t.String(),
            t.Key("created_at"):  t.DateTime(),
            t.Key("custom_headers"):  t.List(t.Dict().allow_extra("*")),
            t.Key("email_address"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("language_code"):  t.String(),
            t.Key("last_notification_at"):  t.DateTime(),
            t.Key("name"):  t.String(),
            t.Key("org_id"):  t.String(),
            t.Key("payload_url"):  t.String(),
            t.Key("policy_count"):  t.Int(),
            t.Key("secret_token"):  t.String(),
            t.Key("uid"):  t.String(),
            t.Key("validate_ssl"):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        channel_type,
        content_type,
        created_at,
        custom_headers,
        email_address,
        id,
        language_code,
        last_notification_at,
        name,
        org_id,
        payload_url,
        policy_count,
        secret_token,
        uid,
        validate_ssl,
    ):
        self.channel_type = channel_type
        self.content_type = content_type
        self.created_at = created_at
        self.custom_headers = custom_headers
        self.email_address = email_address
        self.id = id
        self.language_code = language_code
        self.last_notification_at = last_notification_at
        self.name = name
        self.org_id = org_id
        self.payload_url = payload_url
        self.policy_count = policy_count
        self.secret_token = secret_token
        self.uid = uid
        self.validate_ssl = validate_ssl

    def __repr__(self):
        return (
            "NotificationChannelResponse("
            "channel_type={0.channel_type}, "
            "content_type={0.content_type}, "
            "created_at={0.created_at}, "
            "custom_headers={0.custom_headers}, "
            "email_address={0.email_address}, "
            "id={0.id}, "
            "language_code={0.language_code}, "
            "last_notification_at={0.last_notification_at}, "
            "name={0.name}, "
            "org_id={0.org_id}, "
            "payload_url={0.payload_url}, "
            "policy_count={0.policy_count}, "
            "secret_token={0.secret_token}, "
            "uid={0.uid}, "
            "validate_ssl={0.validate_ssl}, "
        ).format(self)
