#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class NotificationEmailChannelVerification(APIObject):
    """
    Attributes
    ----------
    channel_type:str
         The type of the new notification channel
    email_address:str
         The email address of the recipient
    name:str
         The name of the new notification channel
    org_id:str [optional]
         The id of organization that notification channel belongs to. 
    """
    _converter = t.Dict(
        {
            t.Key("channel_type"):  t.String(),
            t.Key("email_address"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("org_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        channel_type,
        email_address,
        name,
        org_id=None,
    ):
        self.channel_type = channel_type
        self.email_address = email_address
        self.name = name
        self.org_id = org_id

    def __repr__(self):
        return (
            "NotificationEmailChannelVerification("
            "channel_type={0.channel_type}, "
            "email_address={0.email_address}, "
            "name={0.name}, "
            "org_id={0.org_id}, "
        ).format(self)
