#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.request_notification import RequestNotification
from datarobot.models.full_api.generated.model.response_notification import ResponseNotification

class NotificationLogListDataResponse(APIObject):
    """
    Attributes
    ----------
    channel_id:str
         The id of the channel that was used to send the notification
    email_subject:str
         The email subject
    id:str
         The id of the notification log
    parent_notification_id:str, none_type
         The ID of the parent notification
    policy_id:str
         the id of the policy that was used to send the notification
    request:RequestNotification
        
    response:ResponseNotification
        
    retry_count:int
         The count of the retries while sending the notification
    status:str, none_type
         The status of the notification
    timestamp:datetime
         The date and time when the notification was sent
    """
    _converter = t.Dict(
        {
            t.Key("channel_id"):  t.String(),
            t.Key("email_subject"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("parent_notification_id"):  t.String(),
            t.Key("policy_id"):  t.String(),
            t.Key("request"):  t.Any(),
            t.Key("response"):  t.Any(),
            t.Key("retry_count"):  t.Int(),
            t.Key("status"):  t.String(),
            t.Key("timestamp"):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        channel_id,
        email_subject,
        id,
        parent_notification_id,
        policy_id,
        request,
        response,
        retry_count,
        status,
        timestamp,
    ):
        self.channel_id = channel_id
        self.email_subject = email_subject
        self.id = id
        self.parent_notification_id = parent_notification_id
        self.policy_id = policy_id
        self.request = request
        self.response = response
        self.retry_count = retry_count
        self.status = status
        self.timestamp = timestamp

    def __repr__(self):
        return (
            "NotificationLogListDataResponse("
            "channel_id={0.channel_id}, "
            "email_subject={0.email_subject}, "
            "id={0.id}, "
            "parent_notification_id={0.parent_notification_id}, "
            "policy_id={0.policy_id}, "
            "request={0.request}, "
            "response={0.response}, "
            "retry_count={0.retry_count}, "
            "status={0.status}, "
            "timestamp={0.timestamp}, "
        ).format(self)
