#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class NotificationPolicyCreate(APIObject):
    """
    Attributes
    ----------
    channel_id:str
         The id of the notification channel to be used to send the notification.
    name:str
         The name of the new notification policy.
    active:bool [optional]
         Defines if the notification policy is active or not.. 
    event_group:str [optional]
         The group of the event that trigger the notification.. 
    event_type:str [optional]
         The type of the event that triggers the notification.. 
    org_id:str [optional]
         The id of the organization that owns the notification policy.. 
    """
    _converter = t.Dict(
        {
            t.Key("channel_id"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("active", optional=True):  t.Bool(),
            t.Key("event_group", optional=True):  t.String(),
            t.Key("event_type", optional=True):  t.String(),
            t.Key("org_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        channel_id,
        name,
        active=None,
        event_group=None,
        event_type=None,
        org_id=None,
    ):
        self.channel_id = channel_id
        self.name = name
        self.active = active
        self.event_group = event_group
        self.event_type = event_type
        self.org_id = org_id

    def __repr__(self):
        return (
            "NotificationPolicyCreate("
            "channel_id={0.channel_id}, "
            "name={0.name}, "
            "active={0.active}, "
            "event_group={0.event_group}, "
            "event_type={0.event_type}, "
            "org_id={0.org_id}, "
        ).format(self)
