#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.event_group import EventGroup
from datarobot.models.full_api.generated.model.event_type import EventType
from datarobot.models.full_api.generated.model.notification_channel import NotificationChannel

class NotificationPolicyResponse(APIObject):
    """
    Attributes
    ----------
    active:bool
         Defines if the notification policy is active or not.
    channel:NotificationChannel
        
    channel_id:str
         The id of the notification channel to be used to send the notification.
    created:datetime, none_type
         The date when the policy was created.
    event_group:EventGroup
        
    event_type:EventType
        
    id:str
         The id of the policy.
    last_triggered:datetime, none_type
         The date when the last notification with the policy was triggered.
    name:str
         The name of the notification policy.
    org_id:str, none_type
         The id of the organization that owns the notification policy.
    uid:str
         The identifier of the user who created the policy.
    """
    _converter = t.Dict(
        {
            t.Key("active"):  t.Bool(),
            t.Key("channel"):  t.Any(),
            t.Key("channel_id"):  t.String(),
            t.Key("created"):  t.DateTime(),
            t.Key("event_group"):  t.Any(),
            t.Key("event_type"):  t.Any(),
            t.Key("id"):  t.String(),
            t.Key("last_triggered"):  t.DateTime(),
            t.Key("name"):  t.String(),
            t.Key("org_id"):  t.String(),
            t.Key("uid"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        active,
        channel,
        channel_id,
        created,
        event_group,
        event_type,
        id,
        last_triggered,
        name,
        org_id,
        uid,
    ):
        self.active = active
        self.channel = channel
        self.channel_id = channel_id
        self.created = created
        self.event_group = event_group
        self.event_type = event_type
        self.id = id
        self.last_triggered = last_triggered
        self.name = name
        self.org_id = org_id
        self.uid = uid

    def __repr__(self):
        return (
            "NotificationPolicyResponse("
            "active={0.active}, "
            "channel={0.channel}, "
            "channel_id={0.channel_id}, "
            "created={0.created}, "
            "event_group={0.event_group}, "
            "event_type={0.event_type}, "
            "id={0.id}, "
            "last_triggered={0.last_triggered}, "
            "name={0.name}, "
            "org_id={0.org_id}, "
            "uid={0.uid}, "
        ).format(self)
