#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class NotificationPolicyUpdate(APIObject):
    """
    Attributes
    ----------
    active:bool [optional]
         Defines if the notification policy is active or not.. 
    channel_id:str [optional]
         The id of the notification channel to be used to send the notification.. 
    event_group:str [optional]
         The group of the event that trigger the notification.. 
    event_type:str [optional]
         The type of the event that triggers the notification.. 
    name:str [optional]
         The name of the notification policy.. 
    """
    _converter = t.Dict(
        {
            t.Key("active", optional=True):  t.Bool(),
            t.Key("channel_id", optional=True):  t.String(),
            t.Key("event_group", optional=True):  t.String(),
            t.Key("event_type", optional=True):  t.String(),
            t.Key("name", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        active=None,
        channel_id=None,
        event_group=None,
        event_type=None,
        name=None,
    ):
        self.active = active
        self.channel_id = channel_id
        self.event_group = event_group
        self.event_type = event_type
        self.name = name

    def __repr__(self):
        return (
            "NotificationPolicyUpdate("
            "active={0.active}, "
            "channel_id={0.channel_id}, "
            "event_group={0.event_group}, "
            "event_type={0.event_type}, "
            "name={0.name}, "
        ).format(self)
