#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.customer_header import CustomerHeader

class NotificationWebhookChannelTestCreate(APIObject):
    """
    Attributes
    ----------
    channel_type:str
         The type of the new notification channel.
    name:str
         The name of the new notification channel.
    content_type:str [optional]
         The content type of the messages of the new notification channel.. 
    custom_headers:[CustomerHeader] [optional]
         Custom headers and their values to be sent in the new notification channel.. 
    email_address:str [optional]
         The email address to be used in the new notification channel.. 
    org_id:str [optional]
         The identifier of the organization that notification channel belongs to.. 
    payload_url:str [optional]
         The payload URL of the new notification channel.. 
    secret_token:str [optional]
         Secret token to be used for new notification channel.. 
    validate_ssl:bool [optional]
         Whether SSL will be validated in the notification channel.. 
    """
    _converter = t.Dict(
        {
            t.Key("channel_type"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("content_type", optional=True):  t.String(),
            t.Key("custom_headers", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("email_address", optional=True):  t.String(),
            t.Key("org_id", optional=True):  t.String(),
            t.Key("payload_url", optional=True):  t.String(),
            t.Key("secret_token", optional=True):  t.String(),
            t.Key("validate_ssl", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        channel_type,
        name,
        content_type=None,
        custom_headers=None,
        email_address=None,
        org_id=None,
        payload_url=None,
        secret_token=None,
        validate_ssl=None,
    ):
        self.channel_type = channel_type
        self.name = name
        self.content_type = content_type
        self.custom_headers = custom_headers
        self.email_address = email_address
        self.org_id = org_id
        self.payload_url = payload_url
        self.secret_token = secret_token
        self.validate_ssl = validate_ssl

    def __repr__(self):
        return (
            "NotificationWebhookChannelTestCreate("
            "channel_type={0.channel_type}, "
            "name={0.name}, "
            "content_type={0.content_type}, "
            "custom_headers={0.custom_headers}, "
            "email_address={0.email_address}, "
            "org_id={0.org_id}, "
            "payload_url={0.payload_url}, "
            "secret_token={0.secret_token}, "
            "validate_ssl={0.validate_ssl}, "
        ).format(self)
