#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.num_iterations_trained_data import NumIterationsTrainedData

class NumIterationsTrainedResponse(APIObject):
    """
    Attributes
    ----------
    data:[NumIterationsTrainedData]
         Number of estimators or iterations for a single model stage
    model_id:str
         The model ID
    project_id:str
         The project ID
    """
    _converter = t.Dict(
        {
            t.Key("data"):  t.List(t.Dict().allow_extra("*")),
            t.Key("model_id"):  t.String(),
            t.Key("project_id"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        data,
        model_id,
        project_id,
    ):
        self.data = data
        self.model_id = model_id
        self.project_id = project_id

    def __repr__(self):
        return (
            "NumIterationsTrainedResponse("
            "data={0.data}, "
            "model_id={0.model_id}, "
            "project_id={0.project_id}, "
        ).format(self)
