#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class OAuthCredentials(APIObject):
    """
    Attributes
    ----------
    credential_type:str
         The type of these credentials, 'oauth' here.. defaults to "oauth", must be one of ["oauth", ]
    oauth_refresh_token:str
         The oauth refresh token.
    oauth_access_token:str, none_type [optional]
         The oauth access token..  if omitted the server will use the default value of "null"
    oauth_client_id:str, none_type [optional]
         The oauth client ID..  if omitted the server will use the default value of "null"
    oauth_client_secret:str, none_type [optional]
         The oauth client secret..  if omitted the server will use the default value of "null"
    """
    _converter = t.Dict(
        {
            t.Key("credential_type"):  t.String(),
            t.Key("oauth_refresh_token"):  t.String(),
            t.Key("oauth_access_token", optional=True):  t.String(),
            t.Key("oauth_client_id", optional=True):  t.String(),
            t.Key("oauth_client_secret", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        credential_type,
        oauth_refresh_token,
        oauth_access_token=None,
        oauth_client_id=None,
        oauth_client_secret=None,
    ):
        self.credential_type = credential_type
        self.oauth_refresh_token = oauth_refresh_token
        self.oauth_access_token = oauth_access_token
        self.oauth_client_id = oauth_client_id
        self.oauth_client_secret = oauth_client_secret

    def __repr__(self):
        return (
            "OAuthCredentials("
            "credential_type={0.credential_type}, "
            "oauth_refresh_token={0.oauth_refresh_token}, "
            "oauth_access_token={0.oauth_access_token}, "
            "oauth_client_id={0.oauth_client_id}, "
            "oauth_client_secret={0.oauth_client_secret}, "
        ).format(self)
