#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.feature_setting import FeatureSetting
from datarobot.models.full_api.generated.model.periodicity import Periodicity

class OptimizedDatetimePartitioningData(APIObject):
    """
    Attributes
    ----------
    datetime_partition_column:str
         The date column that will be used as a datetime partition column.
    aggregation_type:str [optional]
         For multiseries projects only. The aggregation type to apply when creating cross-series features.. 
    allow_partial_history_time_series_predictions:bool [optional]
         Specifies whether the time series predictions can use partial historical data..  if omitted the server will use the default value of False
    autopilot_cluster_list:[int], none_type [optional]
         A list of integers where each value will be used as the number of clusters in Autopilot model(s) for unsupervised clustering projects. Cannot be specified unless `unsupervisedMode` is true and `unsupervisedType` is set to `clustering`.. 
    autopilot_data_selection_method:str [optional]
         The Data Selection method to be used by autopilot when creating models for datetime-partitioned datasets.. 
    backtests:[bool, date, datetime, dict, float, int, list, str, none_type] [optional]
         An array specifying individual backtests.. 
    calendar_id:str [optional]
         The ID of the calendar to be used in this project.. 
    cross_series_group_by_columns:[str] [optional]
         For multiseries projects with cross-series features enabled only. List of columns (currently of length 1). Setting that indicates how to further split series into related groups. For example, if every series is sales of an individual product, the series group-by could be the product category with values like \"men's clothing\", \"sports equipment\", etc.. 
    default_to_a_priori:bool [optional]
         Renamed to `defaultToKnownInAdvance`.. 
    default_to_do_not_derive:bool [optional]
         For time series projects only. Sets whether all features default to being treated as do-not-derive features, excluding them from feature derivation. Individual features can be set to a value different than the default by using the `featureSettings` parameter.. 
    default_to_known_in_advance:bool [optional]
         For time series projects only. Sets whether all features default to being treated as known in advance features, which are features that are known into the future. Features marked as known in advance must be specified into the future when making predictions. The default is false, all features are not known in advance. Individual features can be set to a value different than the default using the `featureSettings` parameter. See the :ref:`Time Series Overview <time_series_overview>` for more context.. 
    differencing_method:str [optional]
         For time series projects only. Used to specify which differencing method to apply if the data is stationary. For classification problems `simple` and `seasonal` are not allowed. Parameter `periodicities` must be specified if `seasonal` is chosen. Defaults to `auto`.. 
    disable_holdout:bool [optional]
         Whether to suppress allocating a holdout fold. If `disableHoldout` is set to true, `holdoutStartDate` and `holdoutDuration` must not be set..  if omitted the server will use the default value of False
    feature_derivation_window_end:int [optional]
         For time series projects only. How many timeUnits of the datetimePartitionColumn into the past relative to the forecast point the feature derivation window should end.. 
    feature_derivation_window_start:int [optional]
         For time series projects only. How many timeUnits of the datetimePartitionColumn into the past relative to the forecast point the feature derivation window should begin.. 
    feature_settings:[FeatureSetting] [optional]
         An array specifying per feature settings. Features can be left unspecified.. 
    forecast_window_end:int [optional]
         For time series projects only. How many timeUnits of the datetimePartitionColumn into the future relative to the forecast point the forecast window should end.. 
    forecast_window_start:int [optional]
         For time series projects only. How many timeUnits of the datetimePartitionColumn into the future relative to the forecast point the forecast window should start.. 
    gap_duration:str [optional]
         The duration of the gap between holdout training and holdout scoring data. For time series projects, defaults to the duration of the gap between the end of the feature derivation window and the beginning of the forecast window. For OTV projects, defaults to a zero duration (P0Y0M0D).. 
    holdout_duration:str [optional]
         The duration of holdout scoring data. When specifying `holdoutDuration`, `holdoutStartDate` must also be specified. This attribute cannot be specified when `disableHoldout` is true.. 
    holdout_end_date:datetime [optional]
         The end date of holdout scoring data. When specifying `holdoutEndDate`, `holdoutStartDate` must also be specified. This attribute cannot be specified when `disableHoldout` is true.. 
    holdout_start_date:datetime [optional]
         The start date of holdout scoring data. When specifying `holdoutStartDate`, one of `holdoutEndDate` or `holdoutDuration` must also be specified. This attribute cannot be specified when `disableHoldout` is true.. 
    model_splits:int [optional]
         Sets the cap on the number of jobs per model used when building models to control number of jobs in the queue. Higher number of modelSplits will allow for less downsampling leading to the use of more post-processed data. .  if omitted the server will use the default value of 5
    multiseries_id_columns:[str] [optional]
         May be used only with time series projects. An array of the column names identifying  the series to which each row of the dataset belongs. Currently only one multiseries ID column is supported. See the :ref:`multiseries <multiseries>` section of the time series documentation for more context.. 
    number_of_backtests:int [optional]
         The number of backtests to use. If omitted, defaults to a positive value selected by the server based on the validation and gap durations.. 
    periodicities:[Periodicity] [optional]
         A list of periodicities for time series projects only. For classification problems periodicities are not allowed. If this is provided, parameter 'differencing_method' will default to 'seasonal' if not provided or 'auto'.. 
    target:str [optional]
         Name of the target column.. 
    treat_as_exponential:str [optional]
         For time series projects only. Used to specify whether to treat data as exponential trend and apply transformations like log-transform. For classification problems `always` is not allowed. Defaults to `auto`.. 
    unsupervised_mode:bool [optional]
         A boolean value indicating whether an unsupervised project should be created..  if omitted the server will use the default value of False
    unsupervised_type:str, none_type [optional]
         The type of unsupervised project. Only valid when `unsupervisedMode` is true. If `unsupervisedMode`, defaults to `anomaly`.. 
    use_cross_series_features:bool [optional]
         For multiseries projects only. Indicating whether to use cross-series features..  if omitted the server will use the default value of False
    use_supervised_feature_reduction:bool [optional]
         When true, during feature generation DataRobot runs a supervised algorithm that identifies those features with predictive impact on the target and builds feature lists using only qualifying features. Setting false can severely impact autopilot duration, especially for datasets with many features..  if omitted the server will use the default value of True
    use_time_series:bool [optional]
         A boolean value indicating whether a time series project should be created instead of a regular project which uses datetime partitioning..  if omitted the server will use the default value of False
    validation_duration:str [optional]
         The default validation duration for all backtests. If the primary date/time feature in a time series project is irregular, you cannot set a default validation length. Instead, set each duration individually.. 
    windows_basis_unit:str [optional]
         For time series projects only. Indicates which unit is basis for feature derivation window and forecast window. Valid options are detected time unit or `ROW`. If omitted, the default value is detected time unit.. 
    """
    _converter = t.Dict(
        {
            t.Key("datetime_partition_column"):  t.String(),
            t.Key("aggregation_type", optional=True):  t.String(),
            t.Key("allow_partial_history_time_series_predictions", optional=True):  t.Bool(),
            t.Key("autopilot_cluster_list", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("autopilot_data_selection_method", optional=True):  t.String(),
            t.Key("backtests", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("calendar_id", optional=True):  t.String(),
            t.Key("cross_series_group_by_columns", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("default_to_a_priori", optional=True):  t.Bool(),
            t.Key("default_to_do_not_derive", optional=True):  t.Bool(),
            t.Key("default_to_known_in_advance", optional=True):  t.Bool(),
            t.Key("differencing_method", optional=True):  t.String(),
            t.Key("disable_holdout", optional=True):  t.Bool(),
            t.Key("feature_derivation_window_end", optional=True):  t.Int(),
            t.Key("feature_derivation_window_start", optional=True):  t.Int(),
            t.Key("feature_settings", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("forecast_window_end", optional=True):  t.Int(),
            t.Key("forecast_window_start", optional=True):  t.Int(),
            t.Key("gap_duration", optional=True):  t.String(),
            t.Key("holdout_duration", optional=True):  t.String(),
            t.Key("holdout_end_date", optional=True):  t.DateTime(),
            t.Key("holdout_start_date", optional=True):  t.DateTime(),
            t.Key("model_splits", optional=True):  t.Int(),
            t.Key("multiseries_id_columns", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("number_of_backtests", optional=True):  t.Int(),
            t.Key("periodicities", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("target", optional=True):  t.String(),
            t.Key("treat_as_exponential", optional=True):  t.String(),
            t.Key("unsupervised_mode", optional=True):  t.Bool(),
            t.Key("unsupervised_type", optional=True):  t.String(),
            t.Key("use_cross_series_features", optional=True):  t.Bool(),
            t.Key("use_supervised_feature_reduction", optional=True):  t.Bool(),
            t.Key("use_time_series", optional=True):  t.Bool(),
            t.Key("validation_duration", optional=True):  t.String(),
            t.Key("windows_basis_unit", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        datetime_partition_column,
        aggregation_type=None,
        allow_partial_history_time_series_predictions=None,
        autopilot_cluster_list=None,
        autopilot_data_selection_method=None,
        backtests=None,
        calendar_id=None,
        cross_series_group_by_columns=None,
        default_to_a_priori=None,
        default_to_do_not_derive=None,
        default_to_known_in_advance=None,
        differencing_method=None,
        disable_holdout=None,
        feature_derivation_window_end=None,
        feature_derivation_window_start=None,
        feature_settings=None,
        forecast_window_end=None,
        forecast_window_start=None,
        gap_duration=None,
        holdout_duration=None,
        holdout_end_date=None,
        holdout_start_date=None,
        model_splits=None,
        multiseries_id_columns=None,
        number_of_backtests=None,
        periodicities=None,
        target=None,
        treat_as_exponential=None,
        unsupervised_mode=None,
        unsupervised_type=None,
        use_cross_series_features=None,
        use_supervised_feature_reduction=None,
        use_time_series=None,
        validation_duration=None,
        windows_basis_unit=None,
    ):
        self.datetime_partition_column = datetime_partition_column
        self.aggregation_type = aggregation_type
        self.allow_partial_history_time_series_predictions = allow_partial_history_time_series_predictions
        self.autopilot_cluster_list = autopilot_cluster_list
        self.autopilot_data_selection_method = autopilot_data_selection_method
        self.backtests = backtests
        self.calendar_id = calendar_id
        self.cross_series_group_by_columns = cross_series_group_by_columns
        self.default_to_a_priori = default_to_a_priori
        self.default_to_do_not_derive = default_to_do_not_derive
        self.default_to_known_in_advance = default_to_known_in_advance
        self.differencing_method = differencing_method
        self.disable_holdout = disable_holdout
        self.feature_derivation_window_end = feature_derivation_window_end
        self.feature_derivation_window_start = feature_derivation_window_start
        self.feature_settings = feature_settings
        self.forecast_window_end = forecast_window_end
        self.forecast_window_start = forecast_window_start
        self.gap_duration = gap_duration
        self.holdout_duration = holdout_duration
        self.holdout_end_date = holdout_end_date
        self.holdout_start_date = holdout_start_date
        self.model_splits = model_splits
        self.multiseries_id_columns = multiseries_id_columns
        self.number_of_backtests = number_of_backtests
        self.periodicities = periodicities
        self.target = target
        self.treat_as_exponential = treat_as_exponential
        self.unsupervised_mode = unsupervised_mode
        self.unsupervised_type = unsupervised_type
        self.use_cross_series_features = use_cross_series_features
        self.use_supervised_feature_reduction = use_supervised_feature_reduction
        self.use_time_series = use_time_series
        self.validation_duration = validation_duration
        self.windows_basis_unit = windows_basis_unit

    def __repr__(self):
        return (
            "OptimizedDatetimePartitioningData("
            "datetime_partition_column={0.datetime_partition_column}, "
            "aggregation_type={0.aggregation_type}, "
            "allow_partial_history_time_series_predictions={0.allow_partial_history_time_series_predictions}, "
            "autopilot_cluster_list={0.autopilot_cluster_list}, "
            "autopilot_data_selection_method={0.autopilot_data_selection_method}, "
            "backtests={0.backtests}, "
            "calendar_id={0.calendar_id}, "
            "cross_series_group_by_columns={0.cross_series_group_by_columns}, "
            "default_to_a_priori={0.default_to_a_priori}, "
            "default_to_do_not_derive={0.default_to_do_not_derive}, "
            "default_to_known_in_advance={0.default_to_known_in_advance}, "
            "differencing_method={0.differencing_method}, "
            "disable_holdout={0.disable_holdout}, "
            "feature_derivation_window_end={0.feature_derivation_window_end}, "
            "feature_derivation_window_start={0.feature_derivation_window_start}, "
            "feature_settings={0.feature_settings}, "
            "forecast_window_end={0.forecast_window_end}, "
            "forecast_window_start={0.forecast_window_start}, "
            "gap_duration={0.gap_duration}, "
            "holdout_duration={0.holdout_duration}, "
            "holdout_end_date={0.holdout_end_date}, "
            "holdout_start_date={0.holdout_start_date}, "
            "model_splits={0.model_splits}, "
            "multiseries_id_columns={0.multiseries_id_columns}, "
            "number_of_backtests={0.number_of_backtests}, "
            "periodicities={0.periodicities}, "
            "target={0.target}, "
            "treat_as_exponential={0.treat_as_exponential}, "
            "unsupervised_mode={0.unsupervised_mode}, "
            "unsupervised_type={0.unsupervised_type}, "
            "use_cross_series_features={0.use_cross_series_features}, "
            "use_supervised_feature_reduction={0.use_supervised_feature_reduction}, "
            "use_time_series={0.use_time_series}, "
            "validation_duration={0.validation_duration}, "
            "windows_basis_unit={0.windows_basis_unit}, "
        ).format(self)
