#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.datetime_partitioning_response import DatetimePartitioningResponse

class OptimizedDatetimePartitioningList(APIObject):
    """
    Attributes
    ----------
    datetime_partition_column:str
         The date column that will be used as a datetime partition column.
    id:str
         The ID of the datetime partitioning.
    partition_data:DatetimePartitioningResponse
        
    target:str
         The name of the target column.
    """
    _converter = t.Dict(
        {
            t.Key("datetime_partition_column"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("partition_data"):  t.Any(),
            t.Key("target"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        datetime_partition_column,
        id,
        partition_data,
        target,
    ):
        self.datetime_partition_column = datetime_partition_column
        self.id = id
        self.partition_data = partition_data
        self.target = target

    def __repr__(self):
        return (
            "OptimizedDatetimePartitioningList("
            "datetime_partition_column={0.datetime_partition_column}, "
            "id={0.id}, "
            "partition_data={0.partition_data}, "
            "target={0.target}, "
        ).format(self)
