#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class OptionalJDBCQueryDataSource(APIObject):
    """
    Attributes
    ----------
    data_store_id:str [optional]
         Data store ID for this data source.. 
    fetch_size:int [optional]
         User-specified fetch size.. 
    query:str [optional]
         The user-specified SQL query. If this is used, then catalog, schema and table will not be used.. 
    """
    _converter = t.Dict(
        {
            t.Key("data_store_id", optional=True):  t.String(),
            t.Key("fetch_size", optional=True):  t.Int(),
            t.Key("query", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        data_store_id=None,
        fetch_size=None,
        query=None,
    ):
        self.data_store_id = data_store_id
        self.fetch_size = fetch_size
        self.query = query

    def __repr__(self):
        return (
            "OptionalJDBCQueryDataSource("
            "data_store_id={0.data_store_id}, "
            "fetch_size={0.fetch_size}, "
            "query={0.query}, "
        ).format(self)
