#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class OptionalJDBCTableDataSource(APIObject):
    """
    Attributes
    ----------
    catalog:str [optional]
         Catalog name in the database if supported.. 
    data_store_id:str [optional]
         Data store ID for this data source.. 
    fetch_size:int [optional]
         User-specified fetch size.. 
    partition_column:str [optional]
         The name of the partition column. It is needed to allow parallel execution for the 10GB+ projects.. 
    schema:str [optional]
         Schema associated with the table or view in the database if supported.. 
    table:str [optional]
         Table or view name in the database.. 
    """
    _converter = t.Dict(
        {
            t.Key("catalog", optional=True):  t.String(),
            t.Key("data_store_id", optional=True):  t.String(),
            t.Key("fetch_size", optional=True):  t.Int(),
            t.Key("partition_column", optional=True):  t.String(),
            t.Key("schema", optional=True):  t.String(),
            t.Key("table", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        catalog=None,
        data_store_id=None,
        fetch_size=None,
        partition_column=None,
        schema=None,
        table=None,
    ):
        self.catalog = catalog
        self.data_store_id = data_store_id
        self.fetch_size = fetch_size
        self.partition_column = partition_column
        self.schema = schema
        self.table = table

    def __repr__(self):
        return (
            "OptionalJDBCTableDataSource("
            "catalog={0.catalog}, "
            "data_store_id={0.data_store_id}, "
            "fetch_size={0.fetch_size}, "
            "partition_column={0.partition_column}, "
            "schema={0.schema}, "
            "table={0.table}, "
        ).format(self)
