#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class OrganizationJob(APIObject):
    """
    Attributes
    ----------
    job_id:str
         The identifier of the submitted job (unique within a project)
    project_id:str
         The project identifier associated with this job
    project_owner_user_id:str
         Identifier the user that owns the project associated with the job
    project_owner_username:str
         The username of the user that owns the project associated with the job
    user_id:str
         Identifies the user that submitted the job
    username:str
         The username of the user that submitted the job
    """
    _converter = t.Dict(
        {
            t.Key("job_id"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("project_owner_user_id"):  t.String(),
            t.Key("project_owner_username"):  t.String(),
            t.Key("user_id"):  t.String(),
            t.Key("username"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        job_id,
        project_id,
        project_owner_user_id,
        project_owner_username,
        user_id,
        username,
    ):
        self.job_id = job_id
        self.project_id = project_id
        self.project_owner_user_id = project_owner_user_id
        self.project_owner_username = project_owner_username
        self.user_id = user_id
        self.username = username

    def __repr__(self):
        return (
            "OrganizationJob("
            "job_id={0.job_id}, "
            "project_id={0.project_id}, "
            "project_owner_user_id={0.project_owner_user_id}, "
            "project_owner_username={0.project_owner_username}, "
            "user_id={0.user_id}, "
            "username={0.username}, "
        ).format(self)
