#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class OrganizationRetrieve(APIObject):
    """
    Attributes
    ----------
    agreement_status:str
         The status of the organization's agreement to the terms of DataRobot.
    dataset_refresh_job_limit:int, none_type
         How many enabled dataset refresh jobs are allowed per-dataset for this organization.
    dataset_refresh_job_user_limit:int, none_type
         How many enabled dataset refresh jobs are allowed per-user for this organization.
    default_user_max_gpu_workers:int, none_type
         Maximum number of concurrent GPU workers assigned to a newly created user of this organization.
    default_user_max_workers:int, none_type
         Maximum number of concurrent workers assigned to a newly created user of this organization.
    groups_count:int
         The number of user groups belonging to this organization.
    id:str
         The organization identifier.
    inactive_users_count:int
         The number of inactive users for this organization.
    max_deployment_limit:int
         The absolute limit on the number of deployments an organization is allowed to create. A value of zero means unlimited.
    max_eda_workers:int, none_type
         Maximum number of EDA workers assigned available to this organization.
    max_gpu_workers:int, none_type
         Maximum number of concurrent GPU workers available to this organization.
    max_pipeline_module_runtimes:int, none_type
         Maximum number of Pipeline module runtimes available to this organization.
    max_workers:int, none_type
         Maximum number of concurrent workers available to this organization.
    maximum_active_users:int
         The limit for active users for this organization. A value of zero means unlimited.
    members_count:int
         The number of members in this organization.
    name:str, none_type
         The name of the organization.
    orm_version:str
         On-demand Resource Manager (prediction service provisioning) version.
    prepaid_deployment_limit:int
         The number of deployments an organization can create under their contract. When it is reached more deployments can be made, but the user will be warned that this will result in a higher billing. A value of zero means unlimited.
    snapshot_limit:int, none_type
         The number of snapshots allowed for a dataset for this organization.
    support_email:str, none_type
         The support email of the organization.
    account_permissions:{str: (bool,)} [optional]
         Account permissions available to this organization. This will only be present if the corresponding feature flag is set.. 
    desired_custom_model_container_size:int, none_type [optional]
         The desired custom-model memory size. This will only be present if the corresponding feature flag is set.. 
    enable_sso:bool [optional]
         If the SSO is enabled for this organization. This will only be present if the corresponding feature flag is set.. 
    max_custom_model_container_size:int, none_type [optional]
         The maximum memory that might be allocated by the custom-model. This will only be present if the corresponding feature flag is set.. 
    max_custom_model_replicas_per_deployment:int, none_type [optional]
         A fixed number of replicas that will be set for the given custom-model. This will only be present if the corresponding feature flag is set.. 
    max_custom_model_replicas_per_deployment_for_batch_predictions:int, none_type [optional]
         The maximum custom inference model replicas per deployment for batch predictions. This will only be present if the corresponding feature flag is set.. 
    max_upload_size:int, none_type [optional]
         Maximum size for file uploads (MB). This will only be present if the corresponding feature flag is set.. 
    max_upload_size_catalog:int, none_type [optional]
         Maximum size for catalog file uploads (MB). This will only be present if the corresponding feature flag is set.. 
    mlops_event_storage_retention_days:int [optional]
         The number of days to keep MLOps events in storage. Events with older timestamps will be removed..  if omitted the server will use the default value of 0
    restricted_sharing:bool [optional]
         Whether sharing is only allowed within the organization. This will only be present if the corresponding feature flag is set.. 
    """
    _converter = t.Dict(
        {
            t.Key("agreement_status"):  t.String(),
            t.Key("dataset_refresh_job_limit"):  t.Int(),
            t.Key("dataset_refresh_job_user_limit"):  t.Int(),
            t.Key("default_user_max_gpu_workers"):  t.Int(),
            t.Key("default_user_max_workers"):  t.Int(),
            t.Key("groups_count"):  t.Int(),
            t.Key("id"):  t.String(),
            t.Key("inactive_users_count"):  t.Int(),
            t.Key("max_deployment_limit"):  t.Int(),
            t.Key("max_eda_workers"):  t.Int(),
            t.Key("max_gpu_workers"):  t.Int(),
            t.Key("max_pipeline_module_runtimes"):  t.Int(),
            t.Key("max_workers"):  t.Int(),
            t.Key("maximum_active_users"):  t.Int(),
            t.Key("members_count"):  t.Int(),
            t.Key("name"):  t.String(),
            t.Key("orm_version"):  t.String(),
            t.Key("prepaid_deployment_limit"):  t.Int(),
            t.Key("snapshot_limit"):  t.Int(),
            t.Key("support_email"):  t.String(),
            t.Key("account_permissions", optional=True):  t.Mapping(t.String(), t.Any()),
            t.Key("desired_custom_model_container_size", optional=True):  t.Int(),
            t.Key("enable_sso", optional=True):  t.Bool(),
            t.Key("max_custom_model_container_size", optional=True):  t.Int(),
            t.Key("max_custom_model_replicas_per_deployment", optional=True):  t.Int(),
            t.Key("max_custom_model_replicas_per_deployment_for_batch_predictions", optional=True):  t.Int(),
            t.Key("max_upload_size", optional=True):  t.Int(),
            t.Key("max_upload_size_catalog", optional=True):  t.Int(),
            t.Key("mlops_event_storage_retention_days", optional=True):  t.Int(),
            t.Key("restricted_sharing", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        agreement_status,
        dataset_refresh_job_limit,
        dataset_refresh_job_user_limit,
        default_user_max_gpu_workers,
        default_user_max_workers,
        groups_count,
        id,
        inactive_users_count,
        max_deployment_limit,
        max_eda_workers,
        max_gpu_workers,
        max_pipeline_module_runtimes,
        max_workers,
        maximum_active_users,
        members_count,
        name,
        orm_version,
        prepaid_deployment_limit,
        snapshot_limit,
        support_email,
        account_permissions=None,
        desired_custom_model_container_size=None,
        enable_sso=None,
        max_custom_model_container_size=None,
        max_custom_model_replicas_per_deployment=None,
        max_custom_model_replicas_per_deployment_for_batch_predictions=None,
        max_upload_size=None,
        max_upload_size_catalog=None,
        mlops_event_storage_retention_days=None,
        restricted_sharing=None,
    ):
        self.agreement_status = agreement_status
        self.dataset_refresh_job_limit = dataset_refresh_job_limit
        self.dataset_refresh_job_user_limit = dataset_refresh_job_user_limit
        self.default_user_max_gpu_workers = default_user_max_gpu_workers
        self.default_user_max_workers = default_user_max_workers
        self.groups_count = groups_count
        self.id = id
        self.inactive_users_count = inactive_users_count
        self.max_deployment_limit = max_deployment_limit
        self.max_eda_workers = max_eda_workers
        self.max_gpu_workers = max_gpu_workers
        self.max_pipeline_module_runtimes = max_pipeline_module_runtimes
        self.max_workers = max_workers
        self.maximum_active_users = maximum_active_users
        self.members_count = members_count
        self.name = name
        self.orm_version = orm_version
        self.prepaid_deployment_limit = prepaid_deployment_limit
        self.snapshot_limit = snapshot_limit
        self.support_email = support_email
        self.account_permissions = account_permissions
        self.desired_custom_model_container_size = desired_custom_model_container_size
        self.enable_sso = enable_sso
        self.max_custom_model_container_size = max_custom_model_container_size
        self.max_custom_model_replicas_per_deployment = max_custom_model_replicas_per_deployment
        self.max_custom_model_replicas_per_deployment_for_batch_predictions = max_custom_model_replicas_per_deployment_for_batch_predictions
        self.max_upload_size = max_upload_size
        self.max_upload_size_catalog = max_upload_size_catalog
        self.mlops_event_storage_retention_days = mlops_event_storage_retention_days
        self.restricted_sharing = restricted_sharing

    def __repr__(self):
        return (
            "OrganizationRetrieve("
            "agreement_status={0.agreement_status}, "
            "dataset_refresh_job_limit={0.dataset_refresh_job_limit}, "
            "dataset_refresh_job_user_limit={0.dataset_refresh_job_user_limit}, "
            "default_user_max_gpu_workers={0.default_user_max_gpu_workers}, "
            "default_user_max_workers={0.default_user_max_workers}, "
            "groups_count={0.groups_count}, "
            "id={0.id}, "
            "inactive_users_count={0.inactive_users_count}, "
            "max_deployment_limit={0.max_deployment_limit}, "
            "max_eda_workers={0.max_eda_workers}, "
            "max_gpu_workers={0.max_gpu_workers}, "
            "max_pipeline_module_runtimes={0.max_pipeline_module_runtimes}, "
            "max_workers={0.max_workers}, "
            "maximum_active_users={0.maximum_active_users}, "
            "members_count={0.members_count}, "
            "name={0.name}, "
            "orm_version={0.orm_version}, "
            "prepaid_deployment_limit={0.prepaid_deployment_limit}, "
            "snapshot_limit={0.snapshot_limit}, "
            "support_email={0.support_email}, "
            "account_permissions={0.account_permissions}, "
            "desired_custom_model_container_size={0.desired_custom_model_container_size}, "
            "enable_sso={0.enable_sso}, "
            "max_custom_model_container_size={0.max_custom_model_container_size}, "
            "max_custom_model_replicas_per_deployment={0.max_custom_model_replicas_per_deployment}, "
            "max_custom_model_replicas_per_deployment_for_batch_predictions={0.max_custom_model_replicas_per_deployment_for_batch_predictions}, "
            "max_upload_size={0.max_upload_size}, "
            "max_upload_size_catalog={0.max_upload_size_catalog}, "
            "mlops_event_storage_retention_days={0.mlops_event_storage_retention_days}, "
            "restricted_sharing={0.restricted_sharing}, "
        ).format(self)
