#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class OrganizationUser(APIObject):
    """
    Attributes
    ----------
    username:str
         The username of the user to add to the organization
    access_role_id:str [optional]
         [DEPRECATED - Use accessRoleIds instead] ID of the access role assigned to the user being created. 
    access_role_ids:[str] [optional]
         List of access role ids assigned to the user being created. 
    create:bool [optional]
         If the user should be created if not found.  if omitted the server will use the default value of False
    first_name:str [optional]
         First name of the user being created. 
    language:str [optional]
         Language of the user being created. 
    last_name:str [optional]
         Last name of the user being created. 
    org_admin:bool [optional]
         Is this user should be marked as an organizational admin.  if omitted the server will use the default value of False
    password:str [optional]
         Password for the user being created. Should be specified if `create` set to `true`. 
    require_clickthrough:bool [optional]
         Require the user being created to agree to a clickthrough.  if omitted the server will use the default value of False
    """
    _converter = t.Dict(
        {
            t.Key("username"):  t.String(),
            t.Key("access_role_id", optional=True):  t.String(),
            t.Key("access_role_ids", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("create", optional=True):  t.Bool(),
            t.Key("first_name", optional=True):  t.String(),
            t.Key("language", optional=True):  t.String(),
            t.Key("last_name", optional=True):  t.String(),
            t.Key("org_admin", optional=True):  t.Bool(),
            t.Key("password", optional=True):  t.String(),
            t.Key("require_clickthrough", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        username,
        access_role_id=None,
        access_role_ids=None,
        create=None,
        first_name=None,
        language=None,
        last_name=None,
        org_admin=None,
        password=None,
        require_clickthrough=None,
    ):
        self.username = username
        self.access_role_id = access_role_id
        self.access_role_ids = access_role_ids
        self.create = create
        self.first_name = first_name
        self.language = language
        self.last_name = last_name
        self.org_admin = org_admin
        self.password = password
        self.require_clickthrough = require_clickthrough

    def __repr__(self):
        return (
            "OrganizationUser("
            "username={0.username}, "
            "access_role_id={0.access_role_id}, "
            "access_role_ids={0.access_role_ids}, "
            "create={0.create}, "
            "first_name={0.first_name}, "
            "language={0.language}, "
            "last_name={0.last_name}, "
            "org_admin={0.org_admin}, "
            "password={0.password}, "
            "require_clickthrough={0.require_clickthrough}, "
        ).format(self)
