#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class OrganizationUserPatch(APIObject):
    """
    Attributes
    ----------
    access_role_id:str [optional]
         [DEPRECATED - Use accessRoleIds instead] ID of the access role assigned to the user. 
    access_role_ids:[str] [optional]
         List of access role ids assigned to the user. 
    max_workers:int [optional]
         User max workers. 
    org_admin:bool [optional]
         Mark user as an organizational admin. 
    organization_id:str [optional]
         The organization to move the user to. 
    """
    _converter = t.Dict(
        {
            t.Key("access_role_id", optional=True):  t.String(),
            t.Key("access_role_ids", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("max_workers", optional=True):  t.Int(),
            t.Key("org_admin", optional=True):  t.Bool(),
            t.Key("organization_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        access_role_id=None,
        access_role_ids=None,
        max_workers=None,
        org_admin=None,
        organization_id=None,
    ):
        self.access_role_id = access_role_id
        self.access_role_ids = access_role_ids
        self.max_workers = max_workers
        self.org_admin = org_admin
        self.organization_id = organization_id

    def __repr__(self):
        return (
            "OrganizationUserPatch("
            "access_role_id={0.access_role_id}, "
            "access_role_ids={0.access_role_ids}, "
            "max_workers={0.max_workers}, "
            "org_admin={0.org_admin}, "
            "organization_id={0.organization_id}, "
        ).format(self)
