#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class OrganizationUserResponse(APIObject):
    """
    Attributes
    ----------
    activated:bool
         Whether the organization user is activated.
    first_name:str, none_type
         First name of the user being created
    id:str
         The organization user identifier.
    last_name:str, none_type
         Last name of the user being created
    max_workers:int
         Maximum number of concurrent workers available to this user.
    org_admin:bool
         Is this user should be marked as an organizational admin
    organization_id:str
         The organization identifier.
    username:str
         The username of the user to add to the organization
    access_role_ids:[str] [optional]
         List of access role ids assigned to the user. 
    scheduled_for_deletion:bool [optional]
         Whether the user is scheduled for deletion. Only set when a specific feature flag is configured.. 
    """
    _converter = t.Dict(
        {
            t.Key("activated"):  t.Bool(),
            t.Key("first_name"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("last_name"):  t.String(),
            t.Key("max_workers"):  t.Int(),
            t.Key("org_admin"):  t.Bool(),
            t.Key("organization_id"):  t.String(),
            t.Key("username"):  t.String(),
            t.Key("access_role_ids", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("scheduled_for_deletion", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        activated,
        first_name,
        id,
        last_name,
        max_workers,
        org_admin,
        organization_id,
        username,
        access_role_ids=None,
        scheduled_for_deletion=None,
    ):
        self.activated = activated
        self.first_name = first_name
        self.id = id
        self.last_name = last_name
        self.max_workers = max_workers
        self.org_admin = org_admin
        self.organization_id = organization_id
        self.username = username
        self.access_role_ids = access_role_ids
        self.scheduled_for_deletion = scheduled_for_deletion

    def __repr__(self):
        return (
            "OrganizationUserResponse("
            "activated={0.activated}, "
            "first_name={0.first_name}, "
            "id={0.id}, "
            "last_name={0.last_name}, "
            "max_workers={0.max_workers}, "
            "org_admin={0.org_admin}, "
            "organization_id={0.organization_id}, "
            "username={0.username}, "
            "access_role_ids={0.access_role_ids}, "
            "scheduled_for_deletion={0.scheduled_for_deletion}, "
        ).format(self)
