#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.solution_response import SolutionResponse

class ParetoFrontResponse(APIObject):
    """
    Attributes
    ----------
    error_metric:str
         The Eureqa error metric identifier used to compute error metrics for this search. Note that Eureqa error metrics do not correspond 1:1 with DataRobot error metrics - the available metrics are not the same, and even equivalent metrics may be computed slightly differently.
    hyperparameters:bool, date, datetime, dict, float, int, list, str, none_type
         The hyperparameters used by this run of the Eureqa blueprint.
    project_id:str
         The project ID of the Eureqa model.
    solutions:[SolutionResponse]
         The Eureqa model solutions.
    target_type:str
         The type of the target variable.
    """
    _converter = t.Dict(
        {
            t.Key("error_metric"):  t.String(),
            t.Key("hyperparameters"):  t.Any(),
            t.Key("project_id"):  t.String(),
            t.Key("solutions"):  t.List(t.Dict().allow_extra("*")),
            t.Key("target_type"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        error_metric,
        hyperparameters,
        project_id,
        solutions,
        target_type,
    ):
        self.error_metric = error_metric
        self.hyperparameters = hyperparameters
        self.project_id = project_id
        self.solutions = solutions
        self.target_type = target_type

    def __repr__(self):
        return (
            "ParetoFrontResponse("
            "error_metric={0.error_metric}, "
            "hyperparameters={0.hyperparameters}, "
            "project_id={0.project_id}, "
            "solutions={0.solutions}, "
            "target_type={0.target_type}, "
        ).format(self)
