#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class Partition(APIObject):
    """
    Attributes
    ----------
    cv_holdout_level:str, none_type
         If a user partition column was used with cross validation, the value assigned to the holdout set
    cv_method:str
         The partitioning method used. Note that \"date\" partitioning is an old partitioning method no longer supported for new projects, as of API version v2.0.
    datetime_col:str, none_type
         If a date partition column was used, the name of the column. Note that datetimeCol applies to an old partitioning method no longer supported for new projects, as of API version v2.0.
    holdout_level:str, none_type
         If a user partition column was used with train-validation-holdout split, the value assigned to the holdout set.
    holdout_pct:float, none_type
         The percentage of the dataset reserved for the holdout set.
    partition_key_cols:str, none_type
         If group partitioning was used, the name of the column.
    reps:int, none_type
         If cross validation was used, the number of folds to use.
    training_level:str, none_type
         If a user partition column was used with train-validation-holdout split, the value assigned to the training set.
    user_partition_col:str, none_type
         If a user partition column was used, the name of the column.
    validation_level:str, none_type
         If a user partition column was used with train-validation-holdout split, the value assigned to the validation set.
    validation_pct:float, none_type
         If train-validation-holdout split was used, the percentage of the dataset used for the validation set.
    validation_type:str
         The type of validation used.  Either CV (cross validation) or TVH (train-validation-holdout split).
    datetime_partition_column:str, none_type [optional]
         If a datetime partition column was used, the name of the column.. 
    use_time_series:bool, none_type [optional]
         Indicates whether a time series project was created as opposed to a regular project using datetime partitioning.. 
    """
    _converter = t.Dict(
        {
            t.Key("cv_holdout_level"):  t.String(),
            t.Key("cv_method"):  t.String(),
            t.Key("datetime_col"):  t.String(),
            t.Key("holdout_level"):  t.String(),
            t.Key("holdout_pct"):  t.Float(),
            t.Key("partition_key_cols"):  t.String(),
            t.Key("reps"):  t.Int(),
            t.Key("training_level"):  t.String(),
            t.Key("user_partition_col"):  t.String(),
            t.Key("validation_level"):  t.String(),
            t.Key("validation_pct"):  t.Float(),
            t.Key("validation_type"):  t.String(),
            t.Key("datetime_partition_column", optional=True):  t.String(),
            t.Key("use_time_series", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        cv_holdout_level,
        cv_method,
        datetime_col,
        holdout_level,
        holdout_pct,
        partition_key_cols,
        reps,
        training_level,
        user_partition_col,
        validation_level,
        validation_pct,
        validation_type,
        datetime_partition_column=None,
        use_time_series=None,
    ):
        self.cv_holdout_level = cv_holdout_level
        self.cv_method = cv_method
        self.datetime_col = datetime_col
        self.holdout_level = holdout_level
        self.holdout_pct = holdout_pct
        self.partition_key_cols = partition_key_cols
        self.reps = reps
        self.training_level = training_level
        self.user_partition_col = user_partition_col
        self.validation_level = validation_level
        self.validation_pct = validation_pct
        self.validation_type = validation_type
        self.datetime_partition_column = datetime_partition_column
        self.use_time_series = use_time_series

    def __repr__(self):
        return (
            "Partition("
            "cv_holdout_level={0.cv_holdout_level}, "
            "cv_method={0.cv_method}, "
            "datetime_col={0.datetime_col}, "
            "holdout_level={0.holdout_level}, "
            "holdout_pct={0.holdout_pct}, "
            "partition_key_cols={0.partition_key_cols}, "
            "reps={0.reps}, "
            "training_level={0.training_level}, "
            "user_partition_col={0.user_partition_col}, "
            "validation_level={0.validation_level}, "
            "validation_pct={0.validation_pct}, "
            "validation_type={0.validation_type}, "
            "datetime_partition_column={0.datetime_partition_column}, "
            "use_time_series={0.use_time_series}, "
        ).format(self)
