#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PartitioningWarning(APIObject):
    """
    Attributes
    ----------
    backtest_index:int, none_type
         Backtest index. Null if the warning does not correspond to a single backtest.
    partition:str
         Partition name.
    warnings:[str]
         A list of strings representing warnings for the specified partition
    """
    _converter = t.Dict(
        {
            t.Key("backtest_index"):  t.Int(),
            t.Key("partition"):  t.String(),
            t.Key("warnings"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        backtest_index,
        partition,
        warnings,
    ):
        self.backtest_index = backtest_index
        self.partition = partition
        self.warnings = warnings

    def __repr__(self):
        return (
            "PartitioningWarning("
            "backtest_index={0.backtest_index}, "
            "partition={0.partition}, "
            "warnings={0.warnings}, "
        ).format(self)
