#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PayoffMatricesCreate(APIObject):
    """
    Attributes
    ----------
    false_negative_value:float
         False negative value to use for profit curve calculation.
    false_positive_value:float
         False positive value to use for profit curve calculation.
    name:str
         Name of the payoff matrix to be created.
    true_negative_value:float
         True negative value to use for profit curve calculation.
    true_positive_value:float
         True positive value to use for profit curve calculation.
    """
    _converter = t.Dict(
        {
            t.Key("false_negative_value"):  t.Float(),
            t.Key("false_positive_value"):  t.Float(),
            t.Key("name"):  t.String(),
            t.Key("true_negative_value"):  t.Float(),
            t.Key("true_positive_value"):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        false_negative_value,
        false_positive_value,
        name,
        true_negative_value,
        true_positive_value,
    ):
        self.false_negative_value = false_negative_value
        self.false_positive_value = false_positive_value
        self.name = name
        self.true_negative_value = true_negative_value
        self.true_positive_value = true_positive_value

    def __repr__(self):
        return (
            "PayoffMatricesCreate("
            "false_negative_value={0.false_negative_value}, "
            "false_positive_value={0.false_positive_value}, "
            "name={0.name}, "
            "true_negative_value={0.true_negative_value}, "
            "true_positive_value={0.true_positive_value}, "
        ).format(self)
