#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PayoffMatricesResponse(APIObject):
    """
    Attributes
    ----------
    false_negative_value:float
         Payoff value for false negatives used in profit curve calculation.
    false_positive_value:float
         Payoff value for false positives used in profit curve calculation.
    id:str
         ObjectId of the payoff matrix.
    name:str
         Label for the payoff matrix.
    project_id:str
         ID of the project associated with the payoff matrix.
    true_negative_value:float
         Payoff value for true negatives used in profit curve calculation.
    true_positive_value:float
         Payoff value for true positives used in profit curve calculation.
    """
    _converter = t.Dict(
        {
            t.Key("false_negative_value"):  t.Float(),
            t.Key("false_positive_value"):  t.Float(),
            t.Key("id"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("true_negative_value"):  t.Float(),
            t.Key("true_positive_value"):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        false_negative_value,
        false_positive_value,
        id,
        name,
        project_id,
        true_negative_value,
        true_positive_value,
    ):
        self.false_negative_value = false_negative_value
        self.false_positive_value = false_positive_value
        self.id = id
        self.name = name
        self.project_id = project_id
        self.true_negative_value = true_negative_value
        self.true_positive_value = true_positive_value

    def __repr__(self):
        return (
            "PayoffMatricesResponse("
            "false_negative_value={0.false_negative_value}, "
            "false_positive_value={0.false_positive_value}, "
            "id={0.id}, "
            "name={0.name}, "
            "project_id={0.project_id}, "
            "true_negative_value={0.true_negative_value}, "
            "true_positive_value={0.true_positive_value}, "
        ).format(self)
