#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.accuracy_metrics import AccuracyMetrics

class PerClassAccuracy(APIObject):
    """
    Attributes
    ----------
    class_name:str
         The name of the class value for the categorical feature.
    metrics:[AccuracyMetrics]
         An array of metric scores.
    """
    _converter = t.Dict(
        {
            t.Key("class_name"):  t.String(),
            t.Key("metrics"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        class_name,
        metrics,
    ):
        self.class_name = class_name
        self.metrics = metrics

    def __repr__(self):
        return (
            "PerClassAccuracy("
            "class_name={0.class_name}, "
            "metrics={0.metrics}, "
        ).format(self)
