#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PerClassFairness(APIObject):
    """
    Attributes
    ----------
    absolute_value:float
         The absolute fairness score for the class.
    class_name:str
         Name of the protected class the score is calculated for.
    entries_count:int
         The number of entries of the class in the analysed data.
    is_statistically_significant:bool
         Flag to tell whether the score can be treated as statistically significant. In other words, whether we are confident enough with the score for this protected class.
    value:float
         The relative fairness score for the class.
    """
    _converter = t.Dict(
        {
            t.Key("absolute_value"):  t.Float(),
            t.Key("class_name"):  t.String(),
            t.Key("entries_count"):  t.Int(),
            t.Key("is_statistically_significant"):  t.Bool(),
            t.Key("value"):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        absolute_value,
        class_name,
        entries_count,
        is_statistically_significant,
        value,
    ):
        self.absolute_value = absolute_value
        self.class_name = class_name
        self.entries_count = entries_count
        self.is_statistically_significant = is_statistically_significant
        self.value = value

    def __repr__(self):
        return (
            "PerClassFairness("
            "absolute_value={0.absolute_value}, "
            "class_name={0.class_name}, "
            "entries_count={0.entries_count}, "
            "is_statistically_significant={0.is_statistically_significant}, "
            "value={0.value}, "
        ).format(self)
