#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.per_feature_task_missing_report import PerFeatureTaskMissingReport

class PerFeatureMissingReport(APIObject):
    """
    Attributes
    ----------
    feature:str
         The name of the feature
    missing_count:int
         The number of missing values in the training data
    missing_percentage:float
         The percentage of missing values in the training data
    tasks:{str: (PerFeatureTaskMissingReport,)}
         Information on individual tasks of the model which were used to process the feature. The names of properties will be task ids (which correspond to the ids used in the blueprint chart endpoints like :http:get:`/api/v2/projects/(projectId)/blueprints/(blueprintId)/blueprintChart/`) The corresponding value for each task will be of the form `task` described.
    type:str
         The type of the feature, e.g. `Categorical` or `Numeric`
    """
    _converter = t.Dict(
        {
            t.Key("feature"):  t.String(),
            t.Key("missing_count"):  t.Int(),
            t.Key("missing_percentage"):  t.Float(),
            t.Key("tasks"):  t.Mapping(t.String(), t.Any()),
            t.Key("type"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        feature,
        missing_count,
        missing_percentage,
        tasks,
        type,
    ):
        self.feature = feature
        self.missing_count = missing_count
        self.missing_percentage = missing_percentage
        self.tasks = tasks
        self.type = type

    def __repr__(self):
        return (
            "PerFeatureMissingReport("
            "feature={0.feature}, "
            "missing_count={0.missing_count}, "
            "missing_percentage={0.missing_percentage}, "
            "tasks={0.tasks}, "
            "type={0.type}, "
        ).format(self)
