#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PerFeatureTaskMissingReport(APIObject):
    """
    Attributes
    ----------
    descriptions:[str]
         Human readable aggregated information about how the task handles missing values. The following descriptions may be present: what value is imputed for missing values, whether the feature being missing is treated as a feature by the task, whether missing values are treated as infrequent values, whether infrequent values are treated as missing values, and whether missing values are ignored.
    name:str
         Task name, e.g. 'Ordinal encoding of categorical variables'
    """
    _converter = t.Dict(
        {
            t.Key("descriptions"):  t.List(t.Dict().allow_extra("*")),
            t.Key("name"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        descriptions,
        name,
    ):
        self.descriptions = descriptions
        self.name = name

    def __repr__(self):
        return (
            "PerFeatureTaskMissingReport("
            "descriptions={0.descriptions}, "
            "name={0.name}, "
        ).format(self)
