#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PlotDataResponse(APIObject):
    """
    Attributes
    ----------
    actual:float
         The actual value of the target variable for the specified row.
    predicted:float
         The predicted value of the target by the solution for the specified row.
    row:int
         The row number from the raw source data. Used as the X axis for the plot when rendered in the web application.
    """
    _converter = t.Dict(
        {
            t.Key("actual"):  t.Float(),
            t.Key("predicted"):  t.Float(),
            t.Key("row"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        actual,
        predicted,
        row,
    ):
        self.actual = actual
        self.predicted = predicted
        self.row = row

    def __repr__(self):
        return (
            "PlotDataResponse("
            "actual={0.actual}, "
            "predicted={0.predicted}, "
            "row={0.row}, "
        ).format(self)
