#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PPSImageMetadataResponse(APIObject):
    """
    Attributes
    ----------
    base_image_id:str
         Internal base image entity id for troubleshooting purposes
    created:datetime
         ISO formatted image upload date
    docker_image_id:str
         A Docker image id (immutable, content-based) hash associated with the given image
    filename:str
         The name of the file when the download requested
    hash:str
         Hash of the image content, supposed to be used for verifying content after the download. The algorithm used for hashing is specified in `hashAlgorithm` field. Note that hash is calculated over compressed image data.
    hash_algorithm:str
         An algorithm name used for calculating content `hash`. defaults to "SHA256", must be one of ["SHA256", ]
    image_size:int
         Size in bytes of the compressed PPS image data
    short_docker_image_id:str
         A 12-chars shortened version of the `dockerImageId` as shown in 'docker images' command line command output
    datarobot_runtime_image_tag:str, none_type [optional]
         For internal use only.. 
    """
    _converter = t.Dict(
        {
            t.Key("base_image_id"):  t.String(),
            t.Key("created"):  t.DateTime(),
            t.Key("docker_image_id"):  t.String(),
            t.Key("filename"):  t.String(),
            t.Key("hash"):  t.String(),
            t.Key("hash_algorithm"):  t.String(),
            t.Key("image_size"):  t.Int(),
            t.Key("short_docker_image_id"):  t.String(),
            t.Key("datarobot_runtime_image_tag", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        base_image_id,
        created,
        docker_image_id,
        filename,
        hash,
        hash_algorithm,
        image_size,
        short_docker_image_id,
        datarobot_runtime_image_tag=None,
    ):
        self.base_image_id = base_image_id
        self.created = created
        self.docker_image_id = docker_image_id
        self.filename = filename
        self.hash = hash
        self.hash_algorithm = hash_algorithm
        self.image_size = image_size
        self.short_docker_image_id = short_docker_image_id
        self.datarobot_runtime_image_tag = datarobot_runtime_image_tag

    def __repr__(self):
        return (
            "PPSImageMetadataResponse("
            "base_image_id={0.base_image_id}, "
            "created={0.created}, "
            "docker_image_id={0.docker_image_id}, "
            "filename={0.filename}, "
            "hash={0.hash}, "
            "hash_algorithm={0.hash_algorithm}, "
            "image_size={0.image_size}, "
            "short_docker_image_id={0.short_docker_image_id}, "
            "datarobot_runtime_image_tag={0.datarobot_runtime_image_tag}, "
        ).format(self)
