#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PredictedVsActualData(APIObject):
    """
    Attributes
    ----------
    actual:float, none_type
         Actual value. `null` for 0 rows bins and unsupervised time series models.
    label:str
         Contains label for categorical features; For numeric features contains range or numeric value.
    predicted:float, none_type
         Predicted value. `null` for 0 rows bins.
    row_count:int
         Number of rows for the label and bin.
    bin:[str] [optional]
         For numeric features contains labels for left and right bin limits. 
    """
    _converter = t.Dict(
        {
            t.Key("actual"):  t.Float(),
            t.Key("label"):  t.String(),
            t.Key("predicted"):  t.Float(),
            t.Key("row_count"):  t.Int(),
            t.Key("bin", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        actual,
        label,
        predicted,
        row_count,
        bin=None,
    ):
        self.actual = actual
        self.label = label
        self.predicted = predicted
        self.row_count = row_count
        self.bin = bin

    def __repr__(self):
        return (
            "PredictedVsActualData("
            "actual={0.actual}, "
            "label={0.label}, "
            "predicted={0.predicted}, "
            "row_count={0.row_count}, "
            "bin={0.bin}, "
        ).format(self)
