#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PredictionDataSource(APIObject):
    """
    Attributes
    ----------
    data_source_id:str
         The ID of ``DataSource``.
    actual_value_column:str [optional]
         The actual value column name, valid for the prediction files if the project is unsupervised and the dataset is considered as bulk predictions dataset.. 
    credential_data:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         The credentials to authenticate with the database, to use instead of user/password or credential ID.. 
    credential_id:str [optional]
         The credential ID to use for database authentication.. 
    credentials:[bool, date, datetime, dict, float, int, list, str, none_type] [optional]
         A list of credentials for the secondary datasets used in feature discovery project.. 
    forecast_point:datetime [optional]
         For time series projects only. The time in the dataset relative to which predictions are generated. This value is optional. If not specified the default value is the value in the row with the latest specified timestamp. Specifying this value for a project that is not a time series project will result in an error.. 
    password:str [optional]
         The password (in cleartext) for database authentication. The password will be encrypted on the server side in scope of HTTP request and never saved or stored. DEPRECATED: please use ``credentialId`` or ``credentialData`` instead.. 
    predictions_end_date:datetime [optional]
         The end date for bulk predictions, exclusive. Used for time series projects only. Note that this parameter is used for generating historical predictions using the training data, not for future predictions. If not specified, the dataset is not considered as a bulk predictions dataset. This parameter should be provided in conjunction with a ``predictionsStartDate``, and cannot be provided with the ``forecastPoint`` parameter.. 
    predictions_start_date:datetime [optional]
         The start date for bulk predictions. Used for time series projects only. Note that this parameter is used for generating historical predictions using the training data, not for future predictions. If not specified, the dataset is not considered as a bulk predictions dataset. This parameter should be provided in conjunction with a ``predictionsEndDate``, and cannot be provided with the ``forecastPoint`` parameter.. 
    relax_known_in_advance_features_check:bool [optional]
         For time series projects only. If true, missing values in the known in advance features are allowed in the forecast window at the prediction time. This value is optional. If omitted or false, missing values are not allowed.. 
    secondary_datasets_config_id:str [optional]
         For feature discovery projects only. The ID of the alternative secondary dataset config to use during prediction.. 
    use_kerberos:bool [optional]
         If true, use kerberos authentication for database authentication. Default is false..  if omitted the server will use the default value of False
    user:str [optional]
         The username for database authentication. DEPRECATED: please use ``credentialId`` or ``credentialData`` instead.. 
    """
    _converter = t.Dict(
        {
            t.Key("data_source_id"):  t.String(),
            t.Key("actual_value_column", optional=True):  t.String(),
            t.Key("credential_data", optional=True):  t.Any(),
            t.Key("credential_id", optional=True):  t.String(),
            t.Key("credentials", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("forecast_point", optional=True):  t.DateTime(),
            t.Key("password", optional=True):  t.String(),
            t.Key("predictions_end_date", optional=True):  t.DateTime(),
            t.Key("predictions_start_date", optional=True):  t.DateTime(),
            t.Key("relax_known_in_advance_features_check", optional=True):  t.Bool(),
            t.Key("secondary_datasets_config_id", optional=True):  t.String(),
            t.Key("use_kerberos", optional=True):  t.Bool(),
            t.Key("user", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        data_source_id,
        actual_value_column=None,
        credential_data=None,
        credential_id=None,
        credentials=None,
        forecast_point=None,
        password=None,
        predictions_end_date=None,
        predictions_start_date=None,
        relax_known_in_advance_features_check=None,
        secondary_datasets_config_id=None,
        use_kerberos=None,
        user=None,
    ):
        self.data_source_id = data_source_id
        self.actual_value_column = actual_value_column
        self.credential_data = credential_data
        self.credential_id = credential_id
        self.credentials = credentials
        self.forecast_point = forecast_point
        self.password = password
        self.predictions_end_date = predictions_end_date
        self.predictions_start_date = predictions_start_date
        self.relax_known_in_advance_features_check = relax_known_in_advance_features_check
        self.secondary_datasets_config_id = secondary_datasets_config_id
        self.use_kerberos = use_kerberos
        self.user = user

    def __repr__(self):
        return (
            "PredictionDataSource("
            "data_source_id={0.data_source_id}, "
            "actual_value_column={0.actual_value_column}, "
            "credential_data={0.credential_data}, "
            "credential_id={0.credential_id}, "
            "credentials={0.credentials}, "
            "forecast_point={0.forecast_point}, "
            "password={0.password}, "
            "predictions_end_date={0.predictions_end_date}, "
            "predictions_start_date={0.predictions_start_date}, "
            "relax_known_in_advance_features_check={0.relax_known_in_advance_features_check}, "
            "secondary_datasets_config_id={0.secondary_datasets_config_id}, "
            "use_kerberos={0.use_kerberos}, "
            "user={0.user}, "
        ).format(self)
