#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.actual_value_column_info import ActualValueColumnInfo
from datarobot.models.full_api.generated.model.data_quality_warnings_record import DataQualityWarningsRecord

class PredictionDatasetRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    catalog_id:str, none_type
         The ID of the AI catalog entry used to create the prediction, dataset or None if not created from the AI catalog.
    catalog_version_id:str, none_type
         The ID of the AI catalog version used to create the prediction dataset, or None if not created from the AI catalog.
    created:datetime
         The date string of when the dataset was created, of the format`YYYY-mm-ddTHH:MM:SS.ssssssZ`, like ``2016-06-09T11:32:34.170338Z``.
    data_quality_warnings:DataQualityWarningsRecord
        
    forecast_point:str, none_type
         The date string of the forecastPoint of this prediction dataset. Only non-null for time series projects.
    id:str
         The ID of this dataset.
    name:str
         The name of the dataset when it was uploaded.
    num_columns:int
         The number of columns in this dataset.
    num_rows:int
         The number of rows in this dataset.
    predictions_end_date:datetime, none_type
         The date string of the prediction end date of this prediction dataset. Used for bulk predictions. Note that this parameter is for generating historical predictions using the training data. Only non-null for time series projects.
    predictions_start_date:datetime, none_type
         The date string of the prediction start date of this prediction dataset. Used for bulk predictions. Note that this parameter is for generating historical predictions using the training data. Only non-null for time series projects.
    project_id:str
         The project ID that owns this dataset.
    actual_value_column:str, none_type [optional]
         Optional, only available for unsupervised projects, in case dataset was uploaded with actual value column specified. Name of the column which will be used to calculate the classification metrics and insights.. 
    contains_target_values:bool, none_type [optional]
         If True, dataset contains target values and can be used to calculate the classification metrics and insights. Only applies for supervised projects.. 
    data_end_date:datetime [optional]
         Only available for time series projects, a date string representing the maximum primary date of the prediction dataset.. 
    data_start_date:datetime [optional]
         Only available for time series projects, a date string representing the minimum primary date of the prediction dataset.. 
    detected_actual_value_columns:[ActualValueColumnInfo] [optional]
         Only available for unsupervised projects, a list of detected `actualValueColumnInfo` objects which can be used to calculate the classification metrics and insights.. 
    forecast_point_range:[datetime] [optional]
         Only available for time series projects, the start and end of the range of dates available for use as the forecast point, detected based on the uploaded prediction dataset.. 
    max_forecast_date:datetime [optional]
         Only available for time series projects, a date string representing the maximum forecast date of this prediction dataset.. 
    secondary_datasets_config_id:str [optional]
         Only available for Feature discovery projects. Id of the secondary dataset config used by the dataset for the prediction.. 
    """
    _converter = t.Dict(
        {
            t.Key("catalog_id"):  t.String(),
            t.Key("catalog_version_id"):  t.String(),
            t.Key("created"):  t.DateTime(),
            t.Key("data_quality_warnings"):  t.Any(),
            t.Key("forecast_point"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("num_columns"):  t.Int(),
            t.Key("num_rows"):  t.Int(),
            t.Key("predictions_end_date"):  t.DateTime(),
            t.Key("predictions_start_date"):  t.DateTime(),
            t.Key("project_id"):  t.String(),
            t.Key("actual_value_column", optional=True):  t.String(),
            t.Key("contains_target_values", optional=True):  t.Bool(),
            t.Key("data_end_date", optional=True):  t.DateTime(),
            t.Key("data_start_date", optional=True):  t.DateTime(),
            t.Key("detected_actual_value_columns", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("forecast_point_range", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("max_forecast_date", optional=True):  t.DateTime(),
            t.Key("secondary_datasets_config_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        catalog_id,
        catalog_version_id,
        created,
        data_quality_warnings,
        forecast_point,
        id,
        name,
        num_columns,
        num_rows,
        predictions_end_date,
        predictions_start_date,
        project_id,
        actual_value_column=None,
        contains_target_values=None,
        data_end_date=None,
        data_start_date=None,
        detected_actual_value_columns=None,
        forecast_point_range=None,
        max_forecast_date=None,
        secondary_datasets_config_id=None,
    ):
        self.catalog_id = catalog_id
        self.catalog_version_id = catalog_version_id
        self.created = created
        self.data_quality_warnings = data_quality_warnings
        self.forecast_point = forecast_point
        self.id = id
        self.name = name
        self.num_columns = num_columns
        self.num_rows = num_rows
        self.predictions_end_date = predictions_end_date
        self.predictions_start_date = predictions_start_date
        self.project_id = project_id
        self.actual_value_column = actual_value_column
        self.contains_target_values = contains_target_values
        self.data_end_date = data_end_date
        self.data_start_date = data_start_date
        self.detected_actual_value_columns = detected_actual_value_columns
        self.forecast_point_range = forecast_point_range
        self.max_forecast_date = max_forecast_date
        self.secondary_datasets_config_id = secondary_datasets_config_id

    def __repr__(self):
        return (
            "PredictionDatasetRetrieveResponse("
            "catalog_id={0.catalog_id}, "
            "catalog_version_id={0.catalog_version_id}, "
            "created={0.created}, "
            "data_quality_warnings={0.data_quality_warnings}, "
            "forecast_point={0.forecast_point}, "
            "id={0.id}, "
            "name={0.name}, "
            "num_columns={0.num_columns}, "
            "num_rows={0.num_rows}, "
            "predictions_end_date={0.predictions_end_date}, "
            "predictions_start_date={0.predictions_start_date}, "
            "project_id={0.project_id}, "
            "actual_value_column={0.actual_value_column}, "
            "contains_target_values={0.contains_target_values}, "
            "data_end_date={0.data_end_date}, "
            "data_start_date={0.data_start_date}, "
            "detected_actual_value_columns={0.detected_actual_value_columns}, "
            "forecast_point_range={0.forecast_point_range}, "
            "max_forecast_date={0.max_forecast_date}, "
            "secondary_datasets_config_id={0.secondary_datasets_config_id}, "
        ).format(self)
