#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PredictionExplanation(APIObject):
    """
    Attributes
    ----------
    feature:str
         The name of the feature contributing to the prediction.
    feature_value:str
         The value the feature took on for this row. For image features, this value is the URL of the input image (New in v2.21).
    image_explanation_url:str, none_type
         For image features, the URL of the image containing the input image overlaid by the activation heatmap. For non-image features, this field is null.
    label:str
         Describes what this model output corresponds to. For regression projects, it is the name of the target feature. For classification projects, it is a level from the target feature. For Anomaly Detection models it is an Anomaly Score.
    qualitativate_strength:str
         A human-readable description of how strongly the feature affected the prediction (e.g. '+++', '--', '+')
    strength:float
         The amount this feature's value affected the prediction.
    """
    _converter = t.Dict(
        {
            t.Key("feature"):  t.String(),
            t.Key("feature_value"):  t.String(),
            t.Key("image_explanation_url"):  t.String(),
            t.Key("label"):  t.String(),
            t.Key("qualitativate_strength"):  t.String(),
            t.Key("strength"):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        feature,
        feature_value,
        image_explanation_url,
        label,
        qualitativate_strength,
        strength,
    ):
        self.feature = feature
        self.feature_value = feature_value
        self.image_explanation_url = image_explanation_url
        self.label = label
        self.qualitativate_strength = qualitativate_strength
        self.strength = strength

    def __repr__(self):
        return (
            "PredictionExplanation("
            "feature={0.feature}, "
            "feature_value={0.feature_value}, "
            "image_explanation_url={0.image_explanation_url}, "
            "label={0.label}, "
            "qualitativate_strength={0.qualitativate_strength}, "
            "strength={0.strength}, "
        ).format(self)
