#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PredictionExplanationsInitializationCreate(APIObject):
    """
    Attributes
    ----------
    max_explanations:int [optional]
         The maximum number of prediction explanations to supply per row of the dataset..  if omitted the server will use the default value of 3
    threshold_high:float, none_type [optional]
         The high threshold, above which a prediction must score in order for prediction explanations to be computed. If neither thresholdHigh nor thresholdLow is specified, prediction explanations will be computed for all rows.. 
    threshold_low:float, none_type [optional]
         The lower threshold, below which a prediction must score in order for prediction explanations to be computed for a row in the dataset. If neither thresholdHigh nor thresholdLow is specified, prediction explanations will be computed for all rows.. 
    """
    _converter = t.Dict(
        {
            t.Key("max_explanations", optional=True):  t.Int(),
            t.Key("threshold_high", optional=True):  t.Float(),
            t.Key("threshold_low", optional=True):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        max_explanations=None,
        threshold_high=None,
        threshold_low=None,
    ):
        self.max_explanations = max_explanations
        self.threshold_high = threshold_high
        self.threshold_low = threshold_low

    def __repr__(self):
        return (
            "PredictionExplanationsInitializationCreate("
            "max_explanations={0.max_explanations}, "
            "threshold_high={0.threshold_high}, "
            "threshold_low={0.threshold_low}, "
        ).format(self)
