#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.prediction_explanations_row import PredictionExplanationsRow

class PredictionExplanationsInitializationRetrieve(APIObject):
    """
    Attributes
    ----------
    model_id:str
         The model ID.
    prediction_explanations_sample:[PredictionExplanationsRow]
         Each is a PredictionExplanationsRow. They represent a small sample of prediction explanations that could be generated for a particular dataset. They will have the same schema as the `data` array in the response from :http:get:`/api/v2/projects/(projectId)/predictionExplanations/(predictionExplanationsId)/`. As of v2.21 only difference is that there is no forecastPoint in response for time series projects.
    project_id:str
         The project ID.
    """
    _converter = t.Dict(
        {
            t.Key("model_id"):  t.String(),
            t.Key("prediction_explanations_sample"):  t.List(t.Dict().allow_extra("*")),
            t.Key("project_id"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        model_id,
        prediction_explanations_sample,
        project_id,
    ):
        self.model_id = model_id
        self.prediction_explanations_sample = prediction_explanations_sample
        self.project_id = project_id

    def __repr__(self):
        return (
            "PredictionExplanationsInitializationRetrieve("
            "model_id={0.model_id}, "
            "prediction_explanations_sample={0.prediction_explanations_sample}, "
            "project_id={0.project_id}, "
        ).format(self)
