#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PredictionExplanationsPredictionValues(APIObject):
    """
    Attributes
    ----------
    label:str
         Describes what this model output corresponds to. For regression projects, it is the name of the target feature. For classification projects, it is a level from the target feature. For Anomaly Detection models it is an Anomaly Score.
    value:float
         The output of the prediction. For regression projects, it is the predicted value of the target. For classification projects, it is the predicted probability the row belongs to the class identified by the label.
    """
    _converter = t.Dict(
        {
            t.Key("label"):  t.String(),
            t.Key("value"):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        label,
        value,
    ):
        self.label = label
        self.value = value

    def __repr__(self):
        return (
            "PredictionExplanationsPredictionValues("
            "label={0.label}, "
            "value={0.value}, "
        ).format(self)
