#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PredictionExplanationsRecord(APIObject):
    """
    Attributes
    ----------
    dataset_id:str
         The dataset ID.
    finish_time:float
         Timestamp referencing when computation for these prediction explanations finished.
    id:str
         The PredictionExplanationsRecord ID.
    max_explanations:int
         The maximum number of codes generated per prediction.
    model_id:str
         The model ID.
    num_columns:int
         The number of columns prediction explanations were computed for.
    prediction_explanations_location:str
         Where to retrieve the prediction explanations.
    prediction_threshold:float, none_type
         The threshold value used for binary classification prediction.
    project_id:str
         The project ID.
    threshold_high:float, none_type
         The prediction explanation high threshold. Predictions must be above this value (or below the thresholdLow value) to have PredictionExplanations computed.
    threshold_low:float, none_type
         The prediction explanation low threshold. Predictions must be below this value (or above the thresholdHigh value) to have PredictionExplanations computed.
    """
    _converter = t.Dict(
        {
            t.Key("dataset_id"):  t.String(),
            t.Key("finish_time"):  t.Float(),
            t.Key("id"):  t.String(),
            t.Key("max_explanations"):  t.Int(),
            t.Key("model_id"):  t.String(),
            t.Key("num_columns"):  t.Int(),
            t.Key("prediction_explanations_location"):  t.String(),
            t.Key("prediction_threshold"):  t.Float(),
            t.Key("project_id"):  t.String(),
            t.Key("threshold_high"):  t.Float(),
            t.Key("threshold_low"):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        dataset_id,
        finish_time,
        id,
        max_explanations,
        model_id,
        num_columns,
        prediction_explanations_location,
        prediction_threshold,
        project_id,
        threshold_high,
        threshold_low,
    ):
        self.dataset_id = dataset_id
        self.finish_time = finish_time
        self.id = id
        self.max_explanations = max_explanations
        self.model_id = model_id
        self.num_columns = num_columns
        self.prediction_explanations_location = prediction_explanations_location
        self.prediction_threshold = prediction_threshold
        self.project_id = project_id
        self.threshold_high = threshold_high
        self.threshold_low = threshold_low

    def __repr__(self):
        return (
            "PredictionExplanationsRecord("
            "dataset_id={0.dataset_id}, "
            "finish_time={0.finish_time}, "
            "id={0.id}, "
            "max_explanations={0.max_explanations}, "
            "model_id={0.model_id}, "
            "num_columns={0.num_columns}, "
            "prediction_explanations_location={0.prediction_explanations_location}, "
            "prediction_threshold={0.prediction_threshold}, "
            "project_id={0.project_id}, "
            "threshold_high={0.threshold_high}, "
            "threshold_low={0.threshold_low}, "
        ).format(self)
