#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.prediction_explanations_row import PredictionExplanationsRow

class PredictionExplanationsRetrieve(APIObject):
    """
    Attributes
    ----------
    adjustment_method:str
         'exposureNormalized' (for regression projects with exposure) or 'N/A' (for classification projects) The value of 'exposureNormalized' indicates that prediction outputs are adjusted (or divided) by exposure. The value of 'N/A' indicates that no adjustments are applied to the adjusted predictions and they are identical to the unadjusted predictions.
    count:int
         How many rows of prediction explanations were returned.
    data:[PredictionExplanationsRow]
         Each is a PredictionExplanationsRow corresponding to one row of the prediction dataset.
    id:str
         The ID of this group of prediction explanations.
    next:str, none_type
         URL pointing to the next page (if null, there is no next page).
    prediction_explanations_record_location:str
         The URL of the PredictionExplanationsRecord associated with these prediction explanations.
    previous:str, none_type
         URL pointing to the previous page (if null, there is no previous page).
    """
    _converter = t.Dict(
        {
            t.Key("adjustment_method"):  t.String(),
            t.Key("count"):  t.Int(),
            t.Key("data"):  t.List(t.Dict().allow_extra("*")),
            t.Key("id"):  t.String(),
            t.Key("next"):  t.String(),
            t.Key("prediction_explanations_record_location"):  t.String(),
            t.Key("previous"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        adjustment_method,
        count,
        data,
        id,
        next,
        prediction_explanations_record_location,
        previous,
    ):
        self.adjustment_method = adjustment_method
        self.count = count
        self.data = data
        self.id = id
        self.next = next
        self.prediction_explanations_record_location = prediction_explanations_record_location
        self.previous = previous

    def __repr__(self):
        return (
            "PredictionExplanationsRetrieve("
            "adjustment_method={0.adjustment_method}, "
            "count={0.count}, "
            "data={0.data}, "
            "id={0.id}, "
            "next={0.next}, "
            "prediction_explanations_record_location={0.prediction_explanations_record_location}, "
            "previous={0.previous}, "
        ).format(self)
