#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.prediction_explanation import PredictionExplanation
from datarobot.models.full_api.generated.model.prediction_explanations_prediction_values import PredictionExplanationsPredictionValues

class PredictionExplanationsRow(APIObject):
    """
    Attributes
    ----------
    adjusted_prediction:float
         The exposure-adjusted output of the model for this row.
    adjusted_prediction_values:[PredictionExplanationsPredictionValues]
         The exposure-adjusted output of the model for this row.
    forecast_distance:int
         Forecast distance for the row. For time series projects only.
    forecast_point:str
         Forecast point for the row. For time series projects only.
    prediction:float
         The output of the model for this row.
    prediction_explanations:[PredictionExplanation]
         A list of prediction explanations.
    prediction_threshold:float, none_type
         The threshold value used for classification prediction.
    prediction_values:[PredictionExplanationsPredictionValues]
         A list of prediction values.
    row_id:int
         Which row this PredictionExplanationsRow describes.
    series_id:str, none_type
         The ID of the series value for the row in a multiseries project. For a single series project this will be null. For time series projects only.
    timestamp:str
         Timestamp for the row. For time series projects only.
    """
    _converter = t.Dict(
        {
            t.Key("adjusted_prediction"):  t.Float(),
            t.Key("adjusted_prediction_values"):  t.List(t.Dict().allow_extra("*")),
            t.Key("forecast_distance"):  t.Int(),
            t.Key("forecast_point"):  t.String(),
            t.Key("prediction"):  t.Float(),
            t.Key("prediction_explanations"):  t.List(t.Dict().allow_extra("*")),
            t.Key("prediction_threshold"):  t.Float(),
            t.Key("prediction_values"):  t.List(t.Dict().allow_extra("*")),
            t.Key("row_id"):  t.Int(),
            t.Key("series_id"):  t.String(),
            t.Key("timestamp"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        adjusted_prediction,
        adjusted_prediction_values,
        forecast_distance,
        forecast_point,
        prediction,
        prediction_explanations,
        prediction_threshold,
        prediction_values,
        row_id,
        series_id,
        timestamp,
    ):
        self.adjusted_prediction = adjusted_prediction
        self.adjusted_prediction_values = adjusted_prediction_values
        self.forecast_distance = forecast_distance
        self.forecast_point = forecast_point
        self.prediction = prediction
        self.prediction_explanations = prediction_explanations
        self.prediction_threshold = prediction_threshold
        self.prediction_values = prediction_values
        self.row_id = row_id
        self.series_id = series_id
        self.timestamp = timestamp

    def __repr__(self):
        return (
            "PredictionExplanationsRow("
            "adjusted_prediction={0.adjusted_prediction}, "
            "adjusted_prediction_values={0.adjusted_prediction_values}, "
            "forecast_distance={0.forecast_distance}, "
            "forecast_point={0.forecast_point}, "
            "prediction={0.prediction}, "
            "prediction_explanations={0.prediction_explanations}, "
            "prediction_threshold={0.prediction_threshold}, "
            "prediction_values={0.prediction_values}, "
            "row_id={0.row_id}, "
            "series_id={0.series_id}, "
            "timestamp={0.timestamp}, "
        ).format(self)
