#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PredictionExplanationsValues(APIObject):
    """
    Attributes
    ----------
    feature:str
         The name of the feature contributing to the prediction.
    feature_value:bool, date, datetime, dict, float, int, list, str, none_type
         The value the feature took on for this row.
    label:bool, date, datetime, dict, float, int, list, str, none_type
         Describes what output was driven by this prediction explanation. For regression projects, it is the name of the target feature. For classification projects, it is the class whose probability increasing would correspond to a positive strength of this prediction explanation.
    qualitative_strength:str, none_type
         The feature strength as a string, a plus or minus indicator from `+++` to `---`.
    strength:float [optional]
         The feature strength as a float.. 
    """
    _converter = t.Dict(
        {
            t.Key("feature"):  t.String(),
            t.Key("feature_value"):  t.Any(),
            t.Key("label"):  t.Any(),
            t.Key("qualitative_strength"):  t.String(),
            t.Key("strength", optional=True):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        feature,
        feature_value,
        label,
        qualitative_strength,
        strength=None,
    ):
        self.feature = feature
        self.feature_value = feature_value
        self.label = label
        self.qualitative_strength = qualitative_strength
        self.strength = strength

    def __repr__(self):
        return (
            "PredictionExplanationsValues("
            "feature={0.feature}, "
            "feature_value={0.feature_value}, "
            "label={0.label}, "
            "qualitative_strength={0.qualitative_strength}, "
            "strength={0.strength}, "
        ).format(self)
