#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.prediction_options_payload import PredictionOptionsPayload
from datarobot.models.full_api.generated.model.scheduled_job_payload import ScheduledJobPayload

class PredictionIntegrationJobResponse(APIObject):
    """
    Attributes
    ----------
    deployment_id:str
         Id of the deployment used to run predictions
    id:str
         Unique identifier of the prediction integration job
    integration_type_id:str
         Type Id for this integration
    integration_type_name:str
         Name of the integration
    name:str
         Scheduled Job name
    prediction_options:PredictionOptionsPayload
        
    schedule:ScheduledJobPayload
        
    source:bool, date, datetime, dict, float, int, list, str, none_type
         Object describing data source for prediction
    target:bool, date, datetime, dict, float, int, list, str, none_type
         Settings for the predictions output destination
    updated_at:str
         Last updated date in format %B %d, %Y
    updated_by_id:str
         User id of last modifier
    updated_by_name:str
         Name of last modifier
    """
    _converter = t.Dict(
        {
            t.Key("deployment_id"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("integration_type_id"):  t.String(),
            t.Key("integration_type_name"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("prediction_options"):  t.Any(),
            t.Key("schedule"):  t.Any(),
            t.Key("source"):  t.Any(),
            t.Key("target"):  t.Any(),
            t.Key("updated_at"):  t.String(),
            t.Key("updated_by_id"):  t.String(),
            t.Key("updated_by_name"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        deployment_id,
        id,
        integration_type_id,
        integration_type_name,
        name,
        prediction_options,
        schedule,
        source,
        target,
        updated_at,
        updated_by_id,
        updated_by_name,
    ):
        self.deployment_id = deployment_id
        self.id = id
        self.integration_type_id = integration_type_id
        self.integration_type_name = integration_type_name
        self.name = name
        self.prediction_options = prediction_options
        self.schedule = schedule
        self.source = source
        self.target = target
        self.updated_at = updated_at
        self.updated_by_id = updated_by_id
        self.updated_by_name = updated_by_name

    def __repr__(self):
        return (
            "PredictionIntegrationJobResponse("
            "deployment_id={0.deployment_id}, "
            "id={0.id}, "
            "integration_type_id={0.integration_type_id}, "
            "integration_type_name={0.integration_type_name}, "
            "name={0.name}, "
            "prediction_options={0.prediction_options}, "
            "schedule={0.schedule}, "
            "source={0.source}, "
            "target={0.target}, "
            "updated_at={0.updated_at}, "
            "updated_by_id={0.updated_by_id}, "
            "updated_by_name={0.updated_by_name}, "
        ).format(self)
