#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.prediction_options_payload import PredictionOptionsPayload
from datarobot.models.full_api.generated.model.scheduled_job_payload import ScheduledJobPayload

class PredictionIntegrationJobUpdate(APIObject):
    """
    Attributes
    ----------
    integration_type_id:str
         Type Id for this integration
    name:str
         Scheduled Job name
    prediction_options:PredictionOptionsPayload
        
    schedule:ScheduledJobPayload
        
    source:bool, date, datetime, dict, float, int, list, str, none_type
         Object describing data source for prediction
    target:bool, date, datetime, dict, float, int, list, str, none_type
         Settings for the predictions output destination
    """
    _converter = t.Dict(
        {
            t.Key("integration_type_id"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("prediction_options"):  t.Any(),
            t.Key("schedule"):  t.Any(),
            t.Key("source"):  t.Any(),
            t.Key("target"):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        integration_type_id,
        name,
        prediction_options,
        schedule,
        source,
        target,
    ):
        self.integration_type_id = integration_type_id
        self.name = name
        self.prediction_options = prediction_options
        self.schedule = schedule
        self.source = source
        self.target = target

    def __repr__(self):
        return (
            "PredictionIntegrationJobUpdate("
            "integration_type_id={0.integration_type_id}, "
            "name={0.name}, "
            "prediction_options={0.prediction_options}, "
            "schedule={0.schedule}, "
            "source={0.source}, "
            "target={0.target}, "
        ).format(self)
