#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PredictionIntervals(APIObject):
    """
    Attributes
    ----------
    enabled:bool
         Indicates whether prediction intervals are enabled for this deployment. 
    percentiles:[int] [optional]
         The percentiles used for this deployment. Currently, we support at most one percentile at a time.. 
    """
    _converter = t.Dict(
        {
            t.Key("enabled"):  t.Bool(),
            t.Key("percentiles", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        enabled,
        percentiles=None,
    ):
        self.enabled = enabled
        self.percentiles = percentiles

    def __repr__(self):
        return (
            "PredictionIntervals("
            "enabled={0.enabled}, "
            "percentiles={0.percentiles}, "
        ).format(self)
