#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.passthrough_column_definition_payload import PassthroughColumnDefinitionPayload
from datarobot.models.full_api.generated.model.time_series_fields_payload import TimeSeriesFieldsPayload

class PredictionOptionsPayload(APIObject):
    """
    Attributes
    ----------
    error_log_column:bool
         Toggle for saving errors
    overwrite:bool
         Whether to overwrite the existing output or not
    passthrough_columns:[str]
         Array of strings of passthrough columns
    prediction_explanations:int
         Quantity of prediction explanations
    passthrough_columns_schemas:[PassthroughColumnDefinitionPayload], none_type [optional]
         (Only for Tableau) Array of passthrough column description objects with JDBC specific information for each of the users selected passthrough column, if any are included. 
    timeseries_settings:TimeSeriesFieldsPayload [optional]
         
    """
    _converter = t.Dict(
        {
            t.Key("error_log_column"):  t.Bool(),
            t.Key("overwrite"):  t.Bool(),
            t.Key("passthrough_columns"):  t.List(t.Dict().allow_extra("*")),
            t.Key("prediction_explanations"):  t.Int(),
            t.Key("passthrough_columns_schemas", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("timeseries_settings", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        error_log_column,
        overwrite,
        passthrough_columns,
        prediction_explanations,
        passthrough_columns_schemas=None,
        timeseries_settings=None,
    ):
        self.error_log_column = error_log_column
        self.overwrite = overwrite
        self.passthrough_columns = passthrough_columns
        self.prediction_explanations = prediction_explanations
        self.passthrough_columns_schemas = passthrough_columns_schemas
        self.timeseries_settings = timeseries_settings

    def __repr__(self):
        return (
            "PredictionOptionsPayload("
            "error_log_column={0.error_log_column}, "
            "overwrite={0.overwrite}, "
            "passthrough_columns={0.passthrough_columns}, "
            "prediction_explanations={0.prediction_explanations}, "
            "passthrough_columns_schemas={0.passthrough_columns_schemas}, "
            "timeseries_settings={0.timeseries_settings}, "
        ).format(self)
