#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.prediction_explanations_values import PredictionExplanationsValues
from datarobot.models.full_api.generated.model.prediction_values import PredictionValues
from datarobot.models.full_api.generated.model.shap_explanations_metadata_values import ShapExplanationsMetadataValues

class PredictionProxyData(APIObject):
    """
    Attributes
    ----------
    prediction:bool, date, datetime, dict, float, int, list, str, none_type
         In the case of a regression, the value predicted for the target in that row. In the case of any classification type, the class of the target which the row is predicted to belong to.
    prediction_values:[PredictionValues]
         Array of `predictionValue` objects for each class.
    row_id:int
         The row in the prediction dataset this prediction corresponds to.
    deployment_approval_status:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         The approval status of the deployment.. 
    forecast_distance:int [optional]
         In the case of time series project, the number of time units this row is away from the forecastPoint. The unit of time is determined by the timeUnit of the datetime partition column.. 
    forecast_point:datetime [optional]
         For time series projects only. The time in the dataset relative to which predictions were generated.. 
    is_outlier_prediction:bool [optional]
         The outlier warning check result.. 
    passthrough_values:{str: (bool, date, datetime, dict, float, int, list, str, none_type)} [optional]
         
    prediction_explanations:[PredictionExplanationsValues] [optional]
         Array contains `predictionExplanation` objects. Will be present only if `explanationAlgorithm` is not null (prediction explanations were requested).. 
    prediction_intervals:{str: (bool, date, datetime, dict, float, int, list, str, none_type)} [optional]
         
    prediction_threshold:float [optional]
         Threshold used for binary classification in predictions.. 
    series_id:str, none_type [optional]
         The ID of the series value for a multiseries project. For time series projects that are not multiseries this will be a null.. 
    shap_explanations_metadata:[ShapExplanationsMetadataValues] [optional]
         Array contains prediction explanation metadata.. 
    timestamp:datetime [optional]
         The timestamp of this row in the prediction dataset.. 
    """
    _converter = t.Dict(
        {
            t.Key("prediction"):  t.Any(),
            t.Key("prediction_values"):  t.List(t.Dict().allow_extra("*")),
            t.Key("row_id"):  t.Int(),
            t.Key("deployment_approval_status", optional=True):  t.Any(),
            t.Key("forecast_distance", optional=True):  t.Int(),
            t.Key("forecast_point", optional=True):  t.DateTime(),
            t.Key("is_outlier_prediction", optional=True):  t.Bool(),
            t.Key("passthrough_values", optional=True):  t.Any(),
            t.Key("prediction_explanations", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("prediction_intervals", optional=True):  t.Any(),
            t.Key("prediction_threshold", optional=True):  t.Float(),
            t.Key("series_id", optional=True):  t.String(),
            t.Key("shap_explanations_metadata", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("timestamp", optional=True):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        prediction,
        prediction_values,
        row_id,
        deployment_approval_status=None,
        forecast_distance=None,
        forecast_point=None,
        is_outlier_prediction=None,
        passthrough_values=None,
        prediction_explanations=None,
        prediction_intervals=None,
        prediction_threshold=None,
        series_id=None,
        shap_explanations_metadata=None,
        timestamp=None,
    ):
        self.prediction = prediction
        self.prediction_values = prediction_values
        self.row_id = row_id
        self.deployment_approval_status = deployment_approval_status
        self.forecast_distance = forecast_distance
        self.forecast_point = forecast_point
        self.is_outlier_prediction = is_outlier_prediction
        self.passthrough_values = passthrough_values
        self.prediction_explanations = prediction_explanations
        self.prediction_intervals = prediction_intervals
        self.prediction_threshold = prediction_threshold
        self.series_id = series_id
        self.shap_explanations_metadata = shap_explanations_metadata
        self.timestamp = timestamp

    def __repr__(self):
        return (
            "PredictionProxyData("
            "prediction={0.prediction}, "
            "prediction_values={0.prediction_values}, "
            "row_id={0.row_id}, "
            "deployment_approval_status={0.deployment_approval_status}, "
            "forecast_distance={0.forecast_distance}, "
            "forecast_point={0.forecast_point}, "
            "is_outlier_prediction={0.is_outlier_prediction}, "
            "passthrough_values={0.passthrough_values}, "
            "prediction_explanations={0.prediction_explanations}, "
            "prediction_intervals={0.prediction_intervals}, "
            "prediction_threshold={0.prediction_threshold}, "
            "series_id={0.series_id}, "
            "shap_explanations_metadata={0.shap_explanations_metadata}, "
            "timestamp={0.timestamp}, "
        ).format(self)
