#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PredictionRemoteEventData(APIObject):
    """
    Attributes
    ----------
    response_body:str
         The response body message of the prediction event.
    status_code:int
         The response status code of the prediction event.
    error_code:str, none_type [optional]
         The error code if any.. 
    model_id:str, none_type [optional]
         The identifier of the model.. 
    user_id:str, none_type [optional]
         The identifier of the user that accesses the deployment.. 
    """
    _converter = t.Dict(
        {
            t.Key("response_body"):  t.String(),
            t.Key("status_code"):  t.Int(),
            t.Key("error_code", optional=True):  t.String(),
            t.Key("model_id", optional=True):  t.String(),
            t.Key("user_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        response_body,
        status_code,
        error_code=None,
        model_id=None,
        user_id=None,
    ):
        self.response_body = response_body
        self.status_code = status_code
        self.error_code = error_code
        self.model_id = model_id
        self.user_id = user_id

    def __repr__(self):
        return (
            "PredictionRemoteEventData("
            "response_body={0.response_body}, "
            "status_code={0.status_code}, "
            "error_code={0.error_code}, "
            "model_id={0.model_id}, "
            "user_id={0.user_id}, "
        ).format(self)
