#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PredictionResultResponse(APIObject):
    """
    Attributes
    ----------
    actual:bool, date, datetime, dict, float, int, list, str, none_type
         Actual value of the prediction
    association_id:str
         Association id of the prediction, which is used to associate a prediction with its actual value and calculate accuracy.
    model_id:str
         ID of the model used to make these predictions
    predicted:bool, date, datetime, dict, float, int, list, str, none_type
         Predicted value of the prediction
    timestamp:datetime
         When the prediction was made.
    forecast_distance:int, none_type [optional]
         The number of time units this prediction is away from the forecastPoint. The unit of time is determined by the timeUnit of the datetime partition column. For time series models only.. 
    """
    _converter = t.Dict(
        {
            t.Key("actual"):  t.Any(),
            t.Key("association_id"):  t.String(),
            t.Key("model_id"):  t.String(),
            t.Key("predicted"):  t.Any(),
            t.Key("timestamp"):  t.DateTime(),
            t.Key("forecast_distance", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        actual,
        association_id,
        model_id,
        predicted,
        timestamp,
        forecast_distance=None,
    ):
        self.actual = actual
        self.association_id = association_id
        self.model_id = model_id
        self.predicted = predicted
        self.timestamp = timestamp
        self.forecast_distance = forecast_distance

    def __repr__(self):
        return (
            "PredictionResultResponse("
            "actual={0.actual}, "
            "association_id={0.association_id}, "
            "model_id={0.model_id}, "
            "predicted={0.predicted}, "
            "timestamp={0.timestamp}, "
            "forecast_distance={0.forecast_distance}, "
        ).format(self)
