#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.base_prediction_object import BasePredictionObject
from datarobot.models.full_api.generated.model.shap_warning_values import ShapWarningValues

class PredictionRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    includes_prediction_intervals:bool
         For time series projects only. Indicates if prediction intervals will be part of the response. Defaults to False.
    positive_class:bool, date, datetime, dict, float, int, list, str, none_type
         For binary classification, the class of the target deemed the positive class. For regression and multiclass, this field will be null.
    predictions:[BasePredictionObject]
         The json array of predictions. The predictions in the response will have slightly different formats, depending on whether the project used was binary classification, multiclass classification, regression, or unsupervised.
    task:str
         The prediction task. Valid options are 'Binary', 'Multiclass', 'Regression'.
    actual_value_column:str, none_type [optional]
         For time series unsupervised projects only. Will be present only if the prediction dataset has an actual value column. The name of the column with actuals that was used to calculate the scores and insights.. 
    explanation_algorithm:str, none_type [optional]
         The selected algorithm to use for prediction explanations. At present, the only acceptable value is 'shap', which selects the SHapley Additive exPlanations (SHAP) explainer. Defaults to null (no prediction explanations).. 
    feature_derivation_window_counts:int, none_type [optional]
         For time series projects with partial history only. Indicates how many points were used during feature derivation in feature derivation window.. 
    max_explanations:int, none_type [optional]
         The maximum number of prediction explanations values to be returned with each row in the `predictions` json array. Null indicates 'no limit'. Will be present only if `explanationAlgorithm` was set.. 
    prediction_intervals_size:int, none_type [optional]
         For time series projects only. Will be present only if `includePredictionIntervals` is True. Indicates the percentile used for prediction intervals calculation. Defaults to 80.. 
    shap_base_value:float, none_type [optional]
         Will be present only if `explanationAlgorithm` = 'shap'. The model's average prediction over the training data. SHAP values are deviations from the base value.. 
    shap_warnings:[ShapWarningValues], none_type [optional]
         Will be present if `explanationAlgorithm` was set to `shap` and there were additivity failures during SHAP values calculation.. 
    """
    _converter = t.Dict(
        {
            t.Key("includes_prediction_intervals"):  t.Bool(),
            t.Key("positive_class"):  t.Any(),
            t.Key("predictions"):  t.List(t.Dict().allow_extra("*")),
            t.Key("task"):  t.String(),
            t.Key("actual_value_column", optional=True):  t.String(),
            t.Key("explanation_algorithm", optional=True):  t.String(),
            t.Key("feature_derivation_window_counts", optional=True):  t.Int(),
            t.Key("max_explanations", optional=True):  t.Int(),
            t.Key("prediction_intervals_size", optional=True):  t.Int(),
            t.Key("shap_base_value", optional=True):  t.Float(),
            t.Key("shap_warnings", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        includes_prediction_intervals,
        positive_class,
        predictions,
        task,
        actual_value_column=None,
        explanation_algorithm=None,
        feature_derivation_window_counts=None,
        max_explanations=None,
        prediction_intervals_size=None,
        shap_base_value=None,
        shap_warnings=None,
    ):
        self.includes_prediction_intervals = includes_prediction_intervals
        self.positive_class = positive_class
        self.predictions = predictions
        self.task = task
        self.actual_value_column = actual_value_column
        self.explanation_algorithm = explanation_algorithm
        self.feature_derivation_window_counts = feature_derivation_window_counts
        self.max_explanations = max_explanations
        self.prediction_intervals_size = prediction_intervals_size
        self.shap_base_value = shap_base_value
        self.shap_warnings = shap_warnings

    def __repr__(self):
        return (
            "PredictionRetrieveResponse("
            "includes_prediction_intervals={0.includes_prediction_intervals}, "
            "positive_class={0.positive_class}, "
            "predictions={0.predictions}, "
            "task={0.task}, "
            "actual_value_column={0.actual_value_column}, "
            "explanation_algorithm={0.explanation_algorithm}, "
            "feature_derivation_window_counts={0.feature_derivation_window_counts}, "
            "max_explanations={0.max_explanations}, "
            "prediction_intervals_size={0.prediction_intervals_size}, "
            "shap_base_value={0.shap_base_value}, "
            "shap_warnings={0.shap_warnings}, "
        ).format(self)
