#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PredictionURLUpload(APIObject):
    """
    Attributes
    ----------
    url:str
         The URL to download the dataset from.
    actual_value_column:str [optional]
         Actual value column name, valid for the prediction files if the project is unsupervised and the dataset is considered as bulk predictions dataset. This value is optional.. 
    credentials:[bool, date, datetime, dict, float, int, list, str, none_type] [optional]
         A list of credentials for the secondary datasets used in feature discovery project. 
    forecast_point:datetime [optional]
         For time series projects only. The time in the dataset relative to which predictions are generated. If not specified the default value is the value in the row with the latest specified timestamp. Specifying this value for a project that is not a time series project will result in an error.. 
    predictions_end_date:datetime [optional]
         Used for time series projects only. The end date for bulk predictions, exclusive. Note that this parameter is used for generating historical predictions using the training data, not for future predictions. If not specified, the dataset is not considered as a bulk predictions dataset. This parameter should be provided in conjunction with a ``predictionsStartDate``, and cannot be provided with the ``forecastPoint`` parameter.. 
    predictions_start_date:datetime [optional]
         Used for time series projects only. The start date for bulk predictions. Note that this parameter is used for generating historical predictions using the training data, not for future predictions. If not specified, the dataset is not considered as a bulk predictions dataset. This parameter should be provided in conjunction with a ``predictionsEndDate``, and cannot be provided with the ``forecastPoint`` parameter.. 
    relax_known_in_advance_features_check:bool [optional]
         For time series projects only. If true, missing values in the known in advance features are allowed in the forecast window at the prediction time. This value is optional. If omitted or false, missing values are not allowed.. 
    secondary_datasets_config_id:str [optional]
         For feature discovery projects only. The ID of the alternative secondary dataset config to use during prediction.. 
    """
    _converter = t.Dict(
        {
            t.Key("url"):  t.String(),
            t.Key("actual_value_column", optional=True):  t.String(),
            t.Key("credentials", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("forecast_point", optional=True):  t.DateTime(),
            t.Key("predictions_end_date", optional=True):  t.DateTime(),
            t.Key("predictions_start_date", optional=True):  t.DateTime(),
            t.Key("relax_known_in_advance_features_check", optional=True):  t.Bool(),
            t.Key("secondary_datasets_config_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        url,
        actual_value_column=None,
        credentials=None,
        forecast_point=None,
        predictions_end_date=None,
        predictions_start_date=None,
        relax_known_in_advance_features_check=None,
        secondary_datasets_config_id=None,
    ):
        self.url = url
        self.actual_value_column = actual_value_column
        self.credentials = credentials
        self.forecast_point = forecast_point
        self.predictions_end_date = predictions_end_date
        self.predictions_start_date = predictions_start_date
        self.relax_known_in_advance_features_check = relax_known_in_advance_features_check
        self.secondary_datasets_config_id = secondary_datasets_config_id

    def __repr__(self):
        return (
            "PredictionURLUpload("
            "url={0.url}, "
            "actual_value_column={0.actual_value_column}, "
            "credentials={0.credentials}, "
            "forecast_point={0.forecast_point}, "
            "predictions_end_date={0.predictions_end_date}, "
            "predictions_start_date={0.predictions_start_date}, "
            "relax_known_in_advance_features_check={0.relax_known_in_advance_features_check}, "
            "secondary_datasets_config_id={0.secondary_datasets_config_id}, "
        ).format(self)
